/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.observation.MeterObservationHandler;
import io.micrometer.observation.Observation;
import java.util.ArrayList;
import java.util.List;

public class DefaultMeterObservationHandler
implements MeterObservationHandler<Observation.Context> {
    private final MeterRegistry meterRegistry;

    public DefaultMeterObservationHandler(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void onStart(Observation.Context context2) {
        LongTaskTimer.Sample longTaskSample = LongTaskTimer.builder(context2.getName() + ".active").tags(this.createTags(context2)).register(this.meterRegistry).start();
        context2.put(LongTaskTimer.Sample.class, longTaskSample);
        Timer.Sample sample = Timer.start(this.meterRegistry);
        context2.put(Timer.Sample.class, sample);
    }

    @Override
    public void onStop(Observation.Context context2) {
        List<Tag> tags = this.createTags(context2);
        tags.add(Tag.of("error", this.getErrorValue(context2)));
        Timer.Sample sample = (Timer.Sample)context2.getRequired(Timer.Sample.class);
        sample.stop(((Timer.Builder)Timer.builder(context2.getName()).tags(tags)).register(this.meterRegistry));
        LongTaskTimer.Sample longTaskSample = (LongTaskTimer.Sample)context2.getRequired(LongTaskTimer.Sample.class);
        longTaskSample.stop();
    }

    @Override
    public void onEvent(Observation.Event event, Observation.Context context2) {
        Counter.builder(context2.getName() + "." + event.getName()).tags(this.createTags(context2)).register(this.meterRegistry).increment();
    }

    private String getErrorValue(Observation.Context context2) {
        Throwable error = context2.getError();
        return error != null ? error.getClass().getSimpleName() : "none";
    }

    private List<Tag> createTags(Observation.Context context2) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (KeyValue keyValue : context2.getLowCardinalityKeyValues()) {
            tags.add(Tag.of(keyValue.getKey(), keyValue.getValue()));
        }
        return tags;
    }
}

