/*
 * Decompiled with CFR 0.152.
 */
package org.roaringbitmap.buffer;

import org.roaringbitmap.ContainerBatchIterator;
import org.roaringbitmap.buffer.MappeableBitmapContainer;

public final class BitmapBatchIterator
implements ContainerBatchIterator {
    private int wordIndex = 0;
    private long word;
    private MappeableBitmapContainer bitmap;

    public BitmapBatchIterator(MappeableBitmapContainer bitmap) {
        this.wrap(bitmap);
    }

    @Override
    public int next(int key, int[] buffer) {
        int consumed = 0;
        while (consumed < buffer.length) {
            while (this.word == 0L) {
                ++this.wordIndex;
                if (this.wordIndex == 1024) {
                    return consumed;
                }
                this.word = this.bitmap.bitmap.get(this.wordIndex);
            }
            buffer[consumed++] = key + 64 * this.wordIndex + Long.numberOfTrailingZeros(this.word);
            this.word &= this.word - 1L;
        }
        return consumed;
    }

    @Override
    public boolean hasNext() {
        return this.wordIndex < 1024;
    }

    @Override
    public ContainerBatchIterator clone() {
        try {
            return (ContainerBatchIterator)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException(e2);
        }
    }

    @Override
    public void releaseContainer() {
        this.bitmap = null;
    }

    @Override
    public void advanceIfNeeded(char target) {
        this.wordIndex = target >>> 6;
        this.word = this.bitmap.bitmap.get(this.wordIndex);
        this.word &= -(1L << target);
    }

    void wrap(MappeableBitmapContainer bitmap) {
        this.bitmap = bitmap;
        this.word = bitmap.bitmap.get(0);
        this.wordIndex = 0;
    }
}

