/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.TermQuery;

public class CommonTermsQuery
extends Query {
    protected final List<Term> terms = new ArrayList<Term>();
    protected final float maxTermFrequency;
    protected final BooleanClause.Occur lowFreqOccur;
    protected final BooleanClause.Occur highFreqOccur;
    protected float lowFreqBoost = 1.0f;
    protected float highFreqBoost = 1.0f;
    protected float lowFreqMinNrShouldMatch = 0.0f;
    protected float highFreqMinNrShouldMatch = 0.0f;

    public CommonTermsQuery(BooleanClause.Occur highFreqOccur, BooleanClause.Occur lowFreqOccur, float maxTermFrequency) {
        if (highFreqOccur == BooleanClause.Occur.MUST_NOT) {
            throw new IllegalArgumentException("highFreqOccur should be MUST or SHOULD but was MUST_NOT");
        }
        if (lowFreqOccur == BooleanClause.Occur.MUST_NOT) {
            throw new IllegalArgumentException("lowFreqOccur should be MUST or SHOULD but was MUST_NOT");
        }
        this.highFreqOccur = highFreqOccur;
        this.lowFreqOccur = lowFreqOccur;
        this.maxTermFrequency = maxTermFrequency;
    }

    public void add(Term term) {
        if (term == null) {
            throw new IllegalArgumentException("Term must not be null");
        }
        this.terms.add(term);
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        if (this.terms.isEmpty()) {
            return new MatchNoDocsQuery("CommonTermsQuery with no terms");
        }
        if (this.terms.size() == 1) {
            return this.newTermQuery(this.terms.get(0), null);
        }
        List<LeafReaderContext> leaves = reader.leaves();
        int maxDoc = reader.maxDoc();
        TermStates[] contextArray = new TermStates[this.terms.size()];
        Term[] queryTerms = this.terms.toArray(new Term[0]);
        this.collectTermStates(reader, leaves, contextArray, queryTerms);
        return this.buildQuery(maxDoc, contextArray, queryTerms);
    }

    @Override
    public void visit(QueryVisitor visitor) {
        Term[] selectedTerms = (Term[])this.terms.stream().filter(t2 -> visitor.acceptField(t2.field())).toArray(Term[]::new);
        if (selectedTerms.length > 0) {
            QueryVisitor v = visitor.getSubVisitor(BooleanClause.Occur.SHOULD, this);
            v.consumeTerms(this, selectedTerms);
        }
    }

    protected int calcLowFreqMinimumNumberShouldMatch(int numOptional) {
        return this.minNrShouldMatch(this.lowFreqMinNrShouldMatch, numOptional);
    }

    protected int calcHighFreqMinimumNumberShouldMatch(int numOptional) {
        return this.minNrShouldMatch(this.highFreqMinNrShouldMatch, numOptional);
    }

    private final int minNrShouldMatch(float minNrShouldMatch, int numOptional) {
        if (minNrShouldMatch >= 1.0f || minNrShouldMatch == 0.0f) {
            return (int)minNrShouldMatch;
        }
        return Math.round(minNrShouldMatch * (float)numOptional);
    }

    protected Query buildQuery(int maxDoc, TermStates[] contextArray, Term[] queryTerms) {
        ArrayList<Query> lowFreqQueries = new ArrayList<Query>();
        ArrayList<Query> highFreqQueries = new ArrayList<Query>();
        for (int i = 0; i < queryTerms.length; ++i) {
            TermStates termStates = contextArray[i];
            if (termStates == null) {
                lowFreqQueries.add(this.newTermQuery(queryTerms[i], null));
                continue;
            }
            if (this.maxTermFrequency >= 1.0f && (float)termStates.docFreq() > this.maxTermFrequency || termStates.docFreq() > (int)Math.ceil(this.maxTermFrequency * (float)maxDoc)) {
                highFreqQueries.add(this.newTermQuery(queryTerms[i], termStates));
                continue;
            }
            lowFreqQueries.add(this.newTermQuery(queryTerms[i], termStates));
        }
        int numLowFreqClauses = lowFreqQueries.size();
        int numHighFreqClauses = highFreqQueries.size();
        BooleanClause.Occur lowFreqOccur = this.lowFreqOccur;
        BooleanClause.Occur highFreqOccur = this.highFreqOccur;
        int lowFreqMinShouldMatch = 0;
        int highFreqMinShouldMatch = 0;
        if (lowFreqOccur == BooleanClause.Occur.SHOULD && numLowFreqClauses > 0) {
            lowFreqMinShouldMatch = this.calcLowFreqMinimumNumberShouldMatch(numLowFreqClauses);
        }
        if (highFreqOccur == BooleanClause.Occur.SHOULD && numHighFreqClauses > 0) {
            highFreqMinShouldMatch = this.calcHighFreqMinimumNumberShouldMatch(numHighFreqClauses);
        }
        if (lowFreqQueries.isEmpty() && highFreqMinShouldMatch == 0 && highFreqOccur != BooleanClause.Occur.MUST) {
            highFreqOccur = BooleanClause.Occur.MUST;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (!lowFreqQueries.isEmpty()) {
            BooleanQuery.Builder lowFreq = new BooleanQuery.Builder();
            for (Query query2 : lowFreqQueries) {
                lowFreq.add(query2, lowFreqOccur);
            }
            lowFreq.setMinimumNumberShouldMatch(lowFreqMinShouldMatch);
            BooleanQuery lowFreqQuery = lowFreq.build();
            builder.add(new BoostQuery(lowFreqQuery, this.lowFreqBoost), BooleanClause.Occur.MUST);
        }
        if (!highFreqQueries.isEmpty()) {
            BooleanQuery.Builder highFreq = new BooleanQuery.Builder();
            for (Query query2 : highFreqQueries) {
                highFreq.add(query2, highFreqOccur);
            }
            highFreq.setMinimumNumberShouldMatch(highFreqMinShouldMatch);
            BooleanQuery highFreqQuery = highFreq.build();
            builder.add(new BoostQuery(highFreqQuery, this.highFreqBoost), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    public void collectTermStates(IndexReader reader, List<LeafReaderContext> leaves, TermStates[] contextArray, Term[] queryTerms) throws IOException {
        TermsEnum termsEnum = null;
        for (LeafReaderContext context2 : leaves) {
            for (int i = 0; i < queryTerms.length; ++i) {
                Term term = queryTerms[i];
                TermStates termStates = contextArray[i];
                Terms terms = context2.reader().terms(term.field());
                if (terms == null) continue;
                termsEnum = terms.iterator();
                assert (termsEnum != null);
                if (termsEnum == TermsEnum.EMPTY || !termsEnum.seekExact(term.bytes())) continue;
                if (termStates == null) {
                    contextArray[i] = new TermStates(reader.getContext(), termsEnum.termState(), context2.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
                    continue;
                }
                termStates.register(termsEnum.termState(), context2.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
            }
        }
    }

    public void setLowFreqMinimumNumberShouldMatch(float min2) {
        this.lowFreqMinNrShouldMatch = min2;
    }

    public float getLowFreqMinimumNumberShouldMatch() {
        return this.lowFreqMinNrShouldMatch;
    }

    public void setHighFreqMinimumNumberShouldMatch(float min2) {
        this.highFreqMinNrShouldMatch = min2;
    }

    public float getHighFreqMinimumNumberShouldMatch() {
        return this.highFreqMinNrShouldMatch;
    }

    public List<Term> getTerms() {
        return Collections.unmodifiableList(this.terms);
    }

    public float getMaxTermFrequency() {
        return this.maxTermFrequency;
    }

    public BooleanClause.Occur getLowFreqOccur() {
        return this.lowFreqOccur;
    }

    public BooleanClause.Occur getHighFreqOccur() {
        return this.highFreqOccur;
    }

    public float getLowFreqBoost() {
        return this.lowFreqBoost;
    }

    public float getHighFreqBoost() {
        return this.highFreqBoost;
    }

    @Override
    public String toString(String field) {
        boolean needParens;
        StringBuilder buffer = new StringBuilder();
        boolean bl = needParens = this.getLowFreqMinimumNumberShouldMatch() > 0.0f;
        if (needParens) {
            buffer.append("(");
        }
        for (int i = 0; i < this.terms.size(); ++i) {
            Term t2 = this.terms.get(i);
            buffer.append(this.newTermQuery(t2, null).toString());
            if (i == this.terms.size() - 1) continue;
            buffer.append(", ");
        }
        if (needParens) {
            buffer.append(")");
        }
        if (this.getLowFreqMinimumNumberShouldMatch() > 0.0f || this.getHighFreqMinimumNumberShouldMatch() > 0.0f) {
            buffer.append('~');
            buffer.append("(");
            buffer.append(this.getLowFreqMinimumNumberShouldMatch());
            buffer.append(this.getHighFreqMinimumNumberShouldMatch());
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = this.classHash();
        result = 31 * result + Float.floatToIntBits(this.highFreqBoost);
        result = 31 * result + Objects.hashCode((Object)this.highFreqOccur);
        result = 31 * result + Objects.hashCode((Object)this.lowFreqOccur);
        result = 31 * result + Float.floatToIntBits(this.lowFreqBoost);
        result = 31 * result + Float.floatToIntBits(this.maxTermFrequency);
        result = 31 * result + Float.floatToIntBits(this.lowFreqMinNrShouldMatch);
        result = 31 * result + Float.floatToIntBits(this.highFreqMinNrShouldMatch);
        result = 31 * result + Objects.hashCode(this.terms);
        return result;
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((CommonTermsQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(CommonTermsQuery other) {
        return Float.floatToIntBits(this.highFreqBoost) == Float.floatToIntBits(other.highFreqBoost) && this.highFreqOccur == other.highFreqOccur && this.lowFreqOccur == other.lowFreqOccur && Float.floatToIntBits(this.lowFreqBoost) == Float.floatToIntBits(other.lowFreqBoost) && Float.floatToIntBits(this.maxTermFrequency) == Float.floatToIntBits(other.maxTermFrequency) && this.lowFreqMinNrShouldMatch == other.lowFreqMinNrShouldMatch && this.highFreqMinNrShouldMatch == other.highFreqMinNrShouldMatch && this.terms.equals(other.terms);
    }

    protected Query newTermQuery(Term term, TermStates termStates) {
        return termStates == null ? new TermQuery(term) : new TermQuery(term, termStates);
    }
}

