/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.update;

import java.util.Objects;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.http.UpdateExecutionHTTP;
import org.apache.jena.sparql.exec.http.UpdateExecutionHTTPBuilder;
import org.apache.jena.sparql.exec.http.UpdateSendMode;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineRegistry;
import org.apache.jena.sparql.modify.UpdateProcessorStreamingBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecution;
import org.apache.jena.update.UpdateProcessorStreaming;
import org.apache.jena.update.UpdateRequest;

public class UpdateExecutionFactory {
    public static UpdateExecution create(Update update2, Dataset dataset) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), dataset);
    }

    @Deprecated
    public static UpdateExec create(Update update2, DatasetGraph datasetGraph) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), datasetGraph);
    }

    @Deprecated
    public static UpdateExec create(Update update2, Dataset dataset, QuerySolution inputBinding) {
        return UpdateExecutionFactory.create(update2, dataset.asDatasetGraph(), BindingLib.asBinding(inputBinding));
    }

    @Deprecated
    public static UpdateExec create(Update update2, DatasetGraph datasetGraph, Binding inputBinding) {
        return UpdateExecutionFactory.create(new UpdateRequest(update2), datasetGraph, inputBinding);
    }

    public static UpdateExecution create(UpdateRequest updateRequest, Dataset dataset) {
        return UpdateExecutionFactory.make(updateRequest, dataset, null, null);
    }

    @Deprecated
    public static UpdateExec create(UpdateRequest updateRequest, DatasetGraph datasetGraph) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, null, null);
    }

    @Deprecated
    public static UpdateExecution create(UpdateRequest updateRequest, Dataset dataset, QuerySolution inputBinding) {
        return UpdateExecutionFactory.make(updateRequest, dataset, inputBinding, null);
    }

    @Deprecated
    public static UpdateExec create(UpdateRequest updateRequest, DatasetGraph datasetGraph, Binding inputBinding) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, inputBinding, null);
    }

    public static UpdateExecution create(UpdateRequest updateRequest, Dataset dataset, Context context2) {
        return UpdateExecutionFactory.make(updateRequest, dataset, null, context2);
    }

    @Deprecated
    public static UpdateExec create(UpdateRequest updateRequest, DatasetGraph datasetGraph, Context context2) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, null, context2);
    }

    @Deprecated
    public static UpdateExecution create(UpdateRequest updateRequest, Dataset dataset, QuerySolution inputBinding, Context context2) {
        return UpdateExecutionFactory.make(updateRequest, dataset, inputBinding, context2);
    }

    @Deprecated
    public static UpdateExec create(UpdateRequest updateRequest, DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        return UpdateExecutionFactory.make(updateRequest, datasetGraph, inputBinding, context2);
    }

    private static UpdateExecution make(UpdateRequest updateRequest, Dataset dataset, QuerySolution inputBinding, Context context2) {
        return UpdateExecution.dataset(dataset).update(updateRequest).initialBinding(inputBinding).build();
    }

    private static UpdateExec make(UpdateRequest updateRequest, DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        Context cxt = Context.setupContextForDataset(context2, datasetGraph);
        return UpdateExec.newBuilder().update(updateRequest).dataset(datasetGraph).initialBinding(inputBinding).context(cxt).build();
    }

    public static UpdateProcessorStreaming createStreaming(Dataset dataset) {
        return UpdateExecutionFactory.makeStreaming(dataset.asDatasetGraph(), null, null);
    }

    @Deprecated
    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, null, null);
    }

    @Deprecated
    public static UpdateProcessorStreaming createStreaming(Dataset dataset, QuerySolution inputBinding) {
        return UpdateExecutionFactory.createStreaming(dataset.asDatasetGraph(), BindingLib.asBinding(inputBinding));
    }

    @Deprecated
    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph, Binding inputBinding) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, inputBinding, null);
    }

    @Deprecated
    public static UpdateProcessorStreaming createStreaming(Dataset dataset, Context context2) {
        return UpdateExecutionFactory.makeStreaming(dataset.asDatasetGraph(), null, context2);
    }

    @Deprecated
    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph, Context context2) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, null, context2);
    }

    @Deprecated
    public static UpdateProcessorStreaming createStreaming(Dataset dataset, QuerySolution inputBinding, Context context2) {
        return UpdateExecutionFactory.createStreaming(dataset.asDatasetGraph(), BindingLib.asBinding(inputBinding), context2);
    }

    @Deprecated
    public static UpdateProcessorStreaming createStreaming(DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        return UpdateExecutionFactory.makeStreaming(datasetGraph, inputBinding, context2);
    }

    @Deprecated
    private static UpdateProcessorStreaming makeStreaming(DatasetGraph datasetGraph, Binding inputBinding, Context context2) {
        Prologue prologue = new Prologue();
        Context cxt = Context.setupContextForDataset(context2, datasetGraph);
        UpdateEngineFactory f = UpdateEngineRegistry.get().find(datasetGraph, cxt);
        UpdateProcessorStreamingBase uProc = new UpdateProcessorStreamingBase(datasetGraph, inputBinding, prologue, cxt, f);
        return uProc;
    }

    public static UpdateExecution createRemote(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.makeRemote(new UpdateRequest(update2), remoteEndpoint, null);
    }

    @Deprecated
    public static UpdateExecution createRemote(Update update2, String remoteEndpoint, Context context2) {
        return UpdateExecutionFactory.makeRemote(new UpdateRequest(update2), remoteEndpoint, context2);
    }

    @Deprecated
    public static UpdateExecution createRemote(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.makeRemote(updateRequest, remoteEndpoint, null);
    }

    @Deprecated
    public static UpdateExecution createRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context2) {
        return UpdateExecutionFactory.makeRemote(updateRequest, remoteEndpoint, context2);
    }

    @Deprecated
    private static UpdateExecution makeRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context2) {
        return UpdateExecutionFactory.makeRemote(updateRequest, remoteEndpoint, context2, UpdateSendMode.asPost);
    }

    @Deprecated
    public static UpdateExecution createRemoteForm(Update update2, String remoteEndpoint) {
        return UpdateExecutionFactory.makeRemoteForm(new UpdateRequest(update2), remoteEndpoint, null);
    }

    @Deprecated
    public static UpdateExecution createRemoteForm(Update update2, String remoteEndpoint, Context context2) {
        return UpdateExecutionFactory.makeRemoteForm(new UpdateRequest(update2), remoteEndpoint, context2);
    }

    public static UpdateExecution createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint) {
        return UpdateExecutionFactory.makeRemoteForm(updateRequest, remoteEndpoint, null);
    }

    @Deprecated
    public static UpdateExecution createRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context2) {
        return UpdateExecutionFactory.makeRemoteForm(updateRequest, remoteEndpoint, context2);
    }

    @Deprecated
    private static UpdateExecution makeRemoteForm(UpdateRequest updateRequest, String remoteEndpoint, Context context2) {
        return UpdateExecutionFactory.makeRemote(updateRequest, remoteEndpoint, context2, UpdateSendMode.asPostForm);
    }

    private static UpdateExecution makeRemote(UpdateRequest updateRequest, String remoteEndpoint, Context context2, UpdateSendMode updateSendMode) {
        Objects.requireNonNull(updateRequest, "updateRequest");
        Objects.requireNonNull(remoteEndpoint, "remoteEndpoint");
        Objects.requireNonNull(updateSendMode, "updateSendMode");
        context2 = context2 == null ? ARQ.getContext() : context2;
        return (UpdateExecution)((UpdateExecutionHTTPBuilder)((UpdateExecutionHTTPBuilder)((UpdateExecutionHTTPBuilder)((UpdateExecutionHTTPBuilder)UpdateExecutionHTTP.create().context(context2)).endpoint(remoteEndpoint)).update(updateRequest)).sendMode(updateSendMode)).build();
    }
}

