/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.writers;

import java.util.Iterator;
import java.util.Map;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.sse.writers.WriterLib;
import org.apache.jena.sparql.util.FmtUtils;

public class WriterBasePrefix {
    private static final int NL = 1;
    private static final int NoNL = -1;
    private static final int NoSP = -2;

    public static void output(IndentedWriter iWriter, Fmt fmt, Prologue prologue) {
        boolean printBase = false;
        boolean closeBase = WriterBasePrefix.printBase(iWriter, prologue);
        boolean closePrefix = WriterBasePrefix.printPrefix(iWriter, prologue);
        if (fmt != null) {
            fmt.format();
        }
        if (closeBase) {
            WriterLib.finish(iWriter, "base");
        }
        if (closePrefix) {
            WriterLib.finish(iWriter, "prefix");
        }
        iWriter.ensureStartOfLine();
        iWriter.flush();
    }

    private static boolean printBase(IndentedWriter iWriter, Prologue prologue) {
        String baseURI = prologue.getBaseURI();
        if (baseURI != null) {
            WriterLib.start(iWriter, "base", -1);
            iWriter.print(FmtUtils.stringForURI(baseURI));
            iWriter.println();
            return true;
        }
        return false;
    }

    private static boolean printPrefix(IndentedWriter iWriter, Prologue prologue) {
        Map<String, String> m4;
        PrefixMapping prefixMapping = prologue.getPrefixMapping();
        if (prefixMapping != null && !(m4 = prefixMapping.getNsPrefixMap()).isEmpty()) {
            int s2 = iWriter.getCol();
            WriterLib.start(iWriter, "prefix", -1);
            WriterLib.start(iWriter);
            int len = iWriter.getCurrentOffset();
            iWriter.incIndent(len);
            Iterator<String> iter = m4.keySet().iterator();
            boolean first = true;
            while (iter.hasNext()) {
                if (!first) {
                    iWriter.println();
                }
                first = false;
                String prefix = iter.next();
                String uri = prefixMapping.getNsPrefixURI(prefix);
                uri = FmtUtils.stringForURI(uri, prologue.getBaseURI());
                WriterLib.start(iWriter);
                iWriter.print(prefix);
                iWriter.print(": ");
                iWriter.print(uri);
                WriterLib.finish(iWriter);
            }
            iWriter.decIndent(len);
            WriterLib.finish(iWriter);
            iWriter.ensureStartOfLine();
            return true;
        }
        return false;
    }

    public static interface Fmt {
        public void format();
    }
}

