/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import org.apache.jena.atlas.logging.Log;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterNullIterator;
import org.apache.jena.sparql.engine.join.AbstractIterHashJoin;
import org.apache.jena.sparql.engine.join.JoinKey;

public class QueryIterHashJoin
extends AbstractIterHashJoin {
    public static QueryIterator create(JoinKey joinKey, QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        if (!left.hasNext() || !right.hasNext()) {
            left.close();
            right.close();
            return QueryIterNullIterator.create(execCxt);
        }
        if (joinKey != null && joinKey.length() > 1) {
            Log.warn(QueryIterHashJoin.class, "Multivariable join key");
        }
        return new QueryIterHashJoin(joinKey, left, right, execCxt);
    }

    public static QueryIterator create(QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        return QueryIterHashJoin.create(null, left, right, execCxt);
    }

    private QueryIterHashJoin(JoinKey joinKey, QueryIterator left, QueryIterator right, ExecutionContext execCxt) {
        super(joinKey, left, right, execCxt);
    }

    @Override
    protected Binding yieldOneResult(Binding rowCurrentProbe, Binding rowStream, Binding rowResult) {
        return rowResult;
    }

    @Override
    protected Binding noYieldedRows(Binding rowCurrentProbe) {
        return null;
    }

    @Override
    protected QueryIterator joinFinished() {
        return null;
    }
}

