/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.writer.Widths;
import org.apache.jena.riot.writer.WriterStreamRDFBatched;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.util.Context;

public class WriterStreamRDFBlocks
extends WriterStreamRDFBatched {
    protected static final boolean NL_GDFT_START = false;
    protected static final boolean NL_GNMD_START = true;
    protected static final boolean NL_GDFT_END = true;
    protected static final boolean NL_GNMD_END = true;
    protected static final int INDENT_PREDICATE = 8;
    protected static final int MIN_PREDICATE = 6;
    protected static final int LONG_PREDICATE = 30;
    protected static final int LONG_SUBJECT = 20;
    protected static final int INDENT_MIN_S = 6;
    protected static final int INDENT_MAX_S = 14;
    protected static final int GAP_S_P = 2;
    protected static final int GAP_P_O = 2;
    protected static final int INDENT_GDFT = 2;
    protected static final int INDENT_GNMD = 4;
    protected Node lastGraph = null;
    protected Node lastSubject = null;
    protected int currentGraphIndent = 0;
    protected boolean hasRDFprefix = false;

    public WriterStreamRDFBlocks(OutputStream output, Context context2) {
        super(output, context2);
    }

    public WriterStreamRDFBlocks(Writer output, Context context2) {
        super(output, context2);
    }

    public WriterStreamRDFBlocks(IndentedWriter output, Context context2) {
        super(output, context2);
    }

    @Override
    protected void printBatchQuads(Node g2, Node s2, List<Quad> quads) {
        if (g2 == null) {
            g2 = Quad.defaultGraphNodeGenerated;
        }
        if (Objects.equals(g2, this.lastGraph)) {
            this.out.println(" .");
        } else {
            this.endGraph(g2);
            this.startGraph(g2);
            this.lastGraph = g2;
        }
        List<Triple> triples = G.quads2triples(quads.iterator()).toList();
        this.printBatch(s2, triples);
        this.lastSubject = s2;
    }

    private void startBatch() {
        if (this.out.getRow() > 1) {
            this.out.println();
        }
        this.out.flush();
    }

    private void gap(int gap) {
        this.out.print(' ', gap);
    }

    @Override
    public void prefixSetup(String prefix, String iri2) {
        boolean addNL;
        boolean bl = addNL = this.activeTripleData || this.activeQuadData;
        if (addNL) {
            this.out.println();
        }
    }

    @Override
    protected void printBatchTriples(Node s2, List<Triple> triples) {
        this.startBatch();
        this.printBatch(s2, triples);
        this.out.println(" .");
        this.lastGraph = null;
    }

    private void printBatch(Node s2, List<Triple> triples) {
        this.outputNode(s2);
        if (this.out.getCol() > 20) {
            this.out.println();
        } else {
            this.gap(2);
        }
        this.out.incIndent(8);
        this.out.pad();
        this.writePredicateObjectList(triples);
        this.out.decIndent(8);
    }

    private void writePredicateObjectList(Collection<Triple> triples) {
        boolean writeKeyWordType = this.countPrefixesForRDF <= 0;
        int predicateMaxWidth = Widths.calcWidthTriples(this.pMap, this.baseURI, triples, 6, 30, writeKeyWordType);
        boolean first = true;
        for (Triple triple : triples) {
            if (!first) {
                this.out.println(" ;");
            } else {
                first = false;
            }
            Node p = triple.getPredicate();
            this.printProperty(p);
            this.out.pad(predicateMaxWidth);
            this.out.print(' ', 2);
            Node o = triple.getObject();
            this.outputNode(o);
        }
    }

    @Override
    protected void finalizeRun() {
        if (this.lastGraph != null) {
            this.endGraph(null);
        }
    }

    protected boolean dftGraph() {
        return this.lastGraph == Quad.defaultGraphNodeGenerated;
    }

    protected boolean dftGraph(Node g2) {
        return g2 == Quad.defaultGraphNodeGenerated;
    }

    protected void startGraph(Node g2) {
        this.startBatch();
        if (this.lastGraph == null) {
            boolean NL_START = !this.dftGraph(g2);
            this.lastSubject = null;
            if (!this.dftGraph(g2)) {
                this.outputNode(g2);
                this.out.print(" ");
            }
            if (NL_START) {
                this.out.println("{");
            } else {
                this.out.print("{ ");
            }
            if (this.dftGraph()) {
                this.setGraphIndent(2);
            } else {
                int x = NL_START ? 4 : this.out.getCol();
                this.setGraphIndent(x);
            }
            this.out.incIndent(this.graphIndent());
        }
        this.lastGraph = g2;
    }

    protected void endGraph(Node g2) {
        if (this.lastGraph == null) {
            return;
        }
        if (!Objects.equals(this.lastGraph, g2)) {
            boolean NL_END;
            boolean bl = NL_END = this.dftGraph(g2) ? true : true;
            if (this.lastSubject != null) {
                this.out.print(" .");
            }
            if (NL_END) {
                this.out.decIndent(this.graphIndent());
                this.out.println();
                this.out.println("}");
            } else {
                this.out.decIndent(this.graphIndent());
                if (this.out.atLineStart()) {
                    this.out.println("}");
                } else {
                    this.out.println(" }");
                }
            }
            this.lastSubject = null;
            this.lastGraph = null;
        }
    }

    protected void setGraphIndent(int x) {
        this.currentGraphIndent = x;
    }

    protected int graphIndent() {
        return this.currentGraphIndent;
    }
}

