/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.github.jsonldjava.core.JsonLdError;
import com.github.jsonldjava.core.RDFDataset;
import com.github.jsonldjava.core.RDFParser;
import java.util.Iterator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.out.NodeToLabel;
import org.apache.jena.riot.system.SyntaxLabels;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;

class JenaRDF2JSONLD10
implements RDFParser {
    NodeToLabel labels = SyntaxLabels.createNodeToLabel();

    JenaRDF2JSONLD10() {
    }

    @Override
    public RDFDataset parse(Object object) throws JsonLdError {
        RDFDataset result = new RDFDataset();
        if (object instanceof DatasetGraph) {
            DatasetGraph dsg = (DatasetGraph)object;
            Iterator<Quad> iter = dsg.find();
            while (iter.hasNext()) {
                Quad q = iter.next();
                Node s2 = q.getSubject();
                Node p = q.getPredicate();
                Node o = q.getObject();
                Node g2 = q.getGraph();
                String gq = null;
                if (g2 != null && !Quad.isDefaultGraph(g2) && (gq = this.blankNodeOrIRIString(g2)) == null) {
                    throw new RiotException("Graph node is not a URI or a blank node");
                }
                String sq2 = this.blankNodeOrIRIString(s2);
                if (sq2 == null) {
                    throw new RiotException("Subject node is not a URI or a blank node");
                }
                String pq = p.getURI();
                if (o.isLiteral()) {
                    String lex = o.getLiteralLexicalForm();
                    String lang = o.getLiteralLanguage();
                    String dt = o.getLiteralDatatypeURI();
                    if (lang != null && lang.length() == 0) {
                        lang = null;
                    }
                    if (dt == null) {
                        dt = XSDDatatype.XSDstring.getURI();
                    }
                    result.addQuad(sq2, pq, lex, dt, lang, gq);
                    continue;
                }
                String oq = this.blankNodeOrIRIString(o);
                result.addQuad(sq2, pq, oq, gq);
            }
        } else {
            Log.warn(JenaRDF2JSONLD10.class, "unknown");
        }
        return result;
    }

    private String blankNodeOrIRIString(Node x) {
        if (x.isURI()) {
            return x.getURI();
        }
        if (x.isBlank()) {
            return (String)this.labels.get(null, x);
        }
        return null;
    }
}

