/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.reasoner.rulesys.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphMemFactory;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.rulesys.BindingEnvironment;
import org.apache.jena.reasoner.rulesys.ForwardRuleInfGraphI;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.impl.BindingStack;
import org.apache.jena.util.PrintUtil;
import org.apache.jena.util.iterator.ClosableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BFRuleContext
implements RuleContext {
    protected BindingStack env;
    protected Rule rule;
    protected ForwardRuleInfGraphI graph;
    protected List<Triple> stack;
    protected List<Triple> pending;
    protected List<Triple> deletesPending = new ArrayList<Triple>();
    protected Graph pendingCache;
    protected static Logger logger = LoggerFactory.getLogger(BFRuleContext.class);

    public BFRuleContext(ForwardRuleInfGraphI graph) {
        this.graph = graph;
        this.env = new BindingStack();
        this.stack = new ArrayList<Triple>();
        this.pending = new ArrayList<Triple>();
        this.pendingCache = GraphMemFactory.createGraphMem();
    }

    @Override
    public BindingEnvironment getEnv() {
        return this.env;
    }

    public BindingStack getEnvStack() {
        return this.env;
    }

    @Override
    public InfGraph getGraph() {
        return this.graph;
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public void setRule(Rule rule) {
        this.rule = rule;
    }

    public void addTriple(Triple t2) {
        if (this.graph.shouldTrace()) {
            if (this.rule != null) {
                logger.debug("Adding to stack (" + this.rule.toShortString() + "): " + PrintUtil.print(t2));
            } else {
                logger.debug("Adding to stack : " + PrintUtil.print(t2));
            }
        }
        this.stack.add(t2);
    }

    @Override
    public void add(Triple t2) {
        if (this.graph.shouldTrace()) {
            if (this.rule != null) {
                logger.debug("Adding to pending (" + this.rule.toShortString() + "): " + PrintUtil.print(t2));
            } else {
                logger.debug("Adding to pending : " + PrintUtil.print(t2));
            }
        }
        this.pending.add(t2);
    }

    public void flushPending() {
        Iterator<Triple> i = this.pending.iterator();
        while (i.hasNext()) {
            Triple t2 = i.next();
            this.stack.add(t2);
            this.graph.addDeduction(t2);
            i.remove();
        }
        this.pending.clear();
        for (Triple t2 : this.deletesPending) {
            this.graph.delete(t2);
        }
        this.deletesPending.clear();
    }

    @Override
    public boolean contains(Triple t2) {
        return this.contains(t2.getSubject(), t2.getPredicate(), t2.getObject());
    }

    @Override
    public boolean contains(Node s2, Node p, Node o) {
        ClosableIterator<Triple> it = this.find(s2, p, o);
        boolean result = it.hasNext();
        it.close();
        return result;
    }

    @Override
    public ClosableIterator<Triple> find(Node s2, Node p, Node o) {
        return this.graph.findDataMatches(s2, p, o);
    }

    public Triple getNextTriple() {
        if (this.stack.size() > 0) {
            Triple t2 = this.stack.remove(this.stack.size() - 1);
            return t2;
        }
        return null;
    }

    public void resetEnv(int newSize) {
        this.env.reset(newSize);
    }

    @Override
    public void silentAdd(Triple t2) {
        this.graph.silentAdd(t2);
    }

    @Override
    public void remove(Triple t2) {
        this.deletesPending.add(t2);
    }
}

