/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query.text.assembler;

import java.lang.reflect.Constructor;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.text.TextDatasetFactory;
import org.apache.jena.query.text.TextDocProducer;
import org.apache.jena.query.text.TextIndex;
import org.apache.jena.query.text.assembler.TextVocab;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.assembler.DatasetAssembler;
import org.apache.jena.sparql.util.ClsLoader;
import org.apache.jena.sparql.util.graph.GraphUtils;

public class TextDatasetAssembler
extends DatasetAssembler
implements Assembler {
    public static Resource getType() {
        return TextVocab.textDataset;
    }

    @Override
    public DatasetGraph createDataset(Assembler a, Resource root2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Dataset open(Assembler a, Resource root2, Mode mode) {
        Resource dataset = GraphUtils.getResourceValue(root2, TextVocab.pDataset);
        Resource index = GraphUtils.getResourceValue(root2, TextVocab.pIndex);
        Resource textDocProducerNode = GraphUtils.getResourceValue(root2, TextVocab.pTextDocProducer);
        Dataset ds = (Dataset)a.open(dataset);
        TextIndex textIndex = (TextIndex)a.open(index);
        TextDocProducer textDocProducer = null;
        if (null != textDocProducerNode) {
            Class<?> c = ClsLoader.loadClass(textDocProducerNode.getURI(), TextDocProducer.class);
            String className = textDocProducerNode.getURI().substring("java:".length());
            Constructor<?> dyadic = TextDatasetAssembler.getConstructor(c, DatasetGraph.class, TextIndex.class);
            Constructor<?> monadic = TextDatasetAssembler.getConstructor(c, TextIndex.class);
            try {
                if (dyadic != null) {
                    textDocProducer = (TextDocProducer)dyadic.newInstance(ds.asDatasetGraph(), textIndex);
                } else if (monadic != null) {
                    textDocProducer = (TextDocProducer)monadic.newInstance(textIndex);
                } else {
                    Log.warn(ClsLoader.class, "Exception during instantiation '" + className + "' no TextIndex or DatasetGraph,Index constructor");
                }
            }
            catch (Exception ex) {
                Log.warn(ClsLoader.class, "Exception during instantiation '" + className + "': " + ex.getMessage());
                return null;
            }
        }
        Dataset dst = TextDatasetFactory.create(ds, textIndex, true, textDocProducer);
        return dst;
    }

    private static Constructor<?> getConstructor(Class<?> c, Class<?> ... types) {
        try {
            return c.getConstructor(types);
        }
        catch (NoSuchMethodException e2) {
            return null;
        }
    }
}

