/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.jena.Jena;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.lib.Version;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;

public class ModVersion
extends ModBase {
    protected final ArgDecl versionDecl = new ArgDecl(false, "version");
    protected boolean version = false;
    protected boolean printAndExit = false;
    private List<Pair<String, Optional<String>>> descriptions = new ArrayList<Pair<String, Optional<String>>>();

    public ModVersion(boolean printAndExit) {
        this.printAndExit = printAndExit;
    }

    public void addClass(Class<?> c) {
        this.addClass(c.getSimpleName(), c);
    }

    public void addClass(String name, Class<?> cls) {
        Pair<String, Optional<String>> desc = Pair.create(name, Version.versionForClass(cls));
        this.descriptions.add(desc);
    }

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.add(this.versionDecl, "--version", "Version information");
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.contains(this.versionDecl)) {
            this.version = true;
        }
        if (this.version && this.printAndExit) {
            this.printVersionAndExit();
        }
    }

    public boolean getVersionFlag() {
        return this.version;
    }

    public void printVersion() {
        if (this.descriptions.isEmpty()) {
            Version.printVersion(System.out, null, Version.versionForClass(Jena.class));
            return;
        }
        this.descriptions.forEach(p -> Version.printVersion(System.out, (String)p.getLeft(), (Optional)p.getRight()));
    }

    public void printVersionAndExit() {
        this.printVersion();
        System.exit(0);
    }
}

