/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function;

import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.DoubleValuesSource;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.search.SortField;

public abstract class ValueSource {
    public abstract FunctionValues getValues(Map var1, LeafReaderContext var2) throws IOException;

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String description();

    public String toString() {
        return this.description();
    }

    public void createWeight(Map context2, IndexSearcher searcher) throws IOException {
    }

    public static Map newContext(IndexSearcher searcher) {
        IdentityHashMap<String, IndexSearcher> context2 = new IdentityHashMap<String, IndexSearcher>();
        context2.put("searcher", searcher);
        return context2;
    }

    public LongValuesSource asLongValuesSource() {
        return new WrappedLongValuesSource(this);
    }

    public DoubleValuesSource asDoubleValuesSource() {
        return new WrappedDoubleValuesSource(this, null);
    }

    public static ValueSource fromDoubleValuesSource(DoubleValuesSource in) {
        return new FromDoubleValuesSource(in);
    }

    public SortField getSortField(boolean reverse) {
        return new ValueSourceSortField(reverse);
    }

    class ValueSourceComparator
    extends SimpleFieldComparator<Double> {
        private final double[] values;
        private FunctionValues docVals;
        private double bottom;
        private final Map fcontext;
        private double topValue;

        ValueSourceComparator(Map fcontext, int numHits) {
            this.fcontext = fcontext;
            this.values = new double[numHits];
        }

        @Override
        public int compare(int slot1, int slot2) {
            return Double.compare(this.values[slot1], this.values[slot2]);
        }

        @Override
        public int compareBottom(int doc) throws IOException {
            return Double.compare(this.bottom, this.docVals.doubleVal(doc));
        }

        @Override
        public void copy(int slot, int doc) throws IOException {
            this.values[slot] = this.docVals.doubleVal(doc);
        }

        @Override
        public void doSetNextReader(LeafReaderContext context2) throws IOException {
            this.docVals = ValueSource.this.getValues(this.fcontext, context2);
        }

        @Override
        public void setBottom(int bottom) {
            this.bottom = this.values[bottom];
        }

        @Override
        public void setTopValue(Double value) {
            this.topValue = value;
        }

        @Override
        public Double value(int slot) {
            return this.values[slot];
        }

        @Override
        public int compareTop(int doc) throws IOException {
            double docValue = this.docVals.doubleVal(doc);
            return Double.compare(this.topValue, docValue);
        }
    }

    class ValueSourceComparatorSource
    extends FieldComparatorSource {
        private final Map context;

        public ValueSourceComparatorSource(Map context2) {
            this.context = context2;
        }

        public FieldComparator<Double> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) {
            return new ValueSourceComparator(this.context, numHits);
        }
    }

    class ValueSourceSortField
    extends SortField {
        public ValueSourceSortField(boolean reverse) {
            super(ValueSource.this.description(), SortField.Type.REWRITEABLE, reverse);
        }

        @Override
        public SortField rewrite(IndexSearcher searcher) throws IOException {
            Map context2 = ValueSource.newContext(searcher);
            ValueSource.this.createWeight(context2, searcher);
            return new SortField(this.getField(), new ValueSourceComparatorSource(context2), this.getReverse());
        }
    }

    private static class FromDoubleValuesSource
    extends ValueSource {
        final DoubleValuesSource in;

        private FromDoubleValuesSource(DoubleValuesSource in) {
            this.in = in;
        }

        @Override
        public FunctionValues getValues(Map context2, LeafReaderContext readerContext) throws IOException {
            Scorable scorer = (Scorable)context2.get("scorer");
            DoubleValues scores = scorer == null ? null : DoubleValuesSource.fromScorer(scorer);
            IndexSearcher searcher = (IndexSearcher)context2.get("searcher");
            final DoubleValues inner = searcher != null ? this.in.rewrite(searcher).getValues(readerContext, scores) : this.in.getValues(readerContext, scores);
            return new FunctionValues(){

                @Override
                public String toString(int doc) throws IOException {
                    return in.toString();
                }

                @Override
                public float floatVal(int doc) throws IOException {
                    if (!inner.advanceExact(doc)) {
                        return 0.0f;
                    }
                    return (float)inner.doubleValue();
                }

                @Override
                public double doubleVal(int doc) throws IOException {
                    if (!inner.advanceExact(doc)) {
                        return 0.0;
                    }
                    return inner.doubleValue();
                }

                @Override
                public boolean exists(int doc) throws IOException {
                    return inner.advanceExact(doc);
                }
            };
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FromDoubleValuesSource that = (FromDoubleValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String description() {
            return this.in.toString();
        }
    }

    static class WrappedDoubleValuesSource
    extends DoubleValuesSource {
        final ValueSource in;
        final IndexSearcher searcher;

        private WrappedDoubleValuesSource(ValueSource in, IndexSearcher searcher) {
            this.in = in;
            this.searcher = searcher;
        }

        @Override
        public DoubleValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
            HashMap<String, Object> context2 = new HashMap<String, Object>();
            final ScoreAndDoc scorer = new ScoreAndDoc();
            context2.put("scorer", scorer);
            context2.put("searcher", this.searcher);
            final FunctionValues fv = this.in.getValues(context2, ctx);
            return new DoubleValues(){

                @Override
                public double doubleValue() throws IOException {
                    return fv.doubleVal(scorer.current);
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    scorer.current = doc;
                    scorer.score = scores != null && scores.advanceExact(doc) ? (float)scores.doubleValue() : 0.0f;
                    return true;
                }
            };
        }

        @Override
        public boolean needsScores() {
            return true;
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public Explanation explain(LeafReaderContext ctx, int docId, Explanation scoreExplanation) throws IOException {
            HashMap<String, Object> context2 = new HashMap<String, Object>();
            ScoreAndDoc scorer = new ScoreAndDoc();
            scorer.score = scoreExplanation.getValue().floatValue();
            context2.put("scorer", scorer);
            context2.put("searcher", this.searcher);
            FunctionValues fv = this.in.getValues(context2, ctx);
            return fv.explain(docId);
        }

        @Override
        public DoubleValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return new WrappedDoubleValuesSource(this.in, searcher);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedDoubleValuesSource that = (WrappedDoubleValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String toString() {
            return this.in.toString();
        }
    }

    private static class WrappedLongValuesSource
    extends LongValuesSource {
        private final ValueSource in;

        private WrappedLongValuesSource(ValueSource in) {
            this.in = in;
        }

        @Override
        public LongValues getValues(LeafReaderContext ctx, final DoubleValues scores) throws IOException {
            IdentityHashMap<String, ScoreAndDoc> context2 = new IdentityHashMap<String, ScoreAndDoc>();
            final ScoreAndDoc scorer = new ScoreAndDoc();
            context2.put("scorer", scorer);
            final FunctionValues fv = this.in.getValues(context2, ctx);
            return new LongValues(){

                @Override
                public long longValue() throws IOException {
                    return fv.longVal(scorer.current);
                }

                @Override
                public boolean advanceExact(int doc) throws IOException {
                    scorer.current = doc;
                    scorer.score = scores != null && scores.advanceExact(doc) ? (float)scores.doubleValue() : 0.0f;
                    return fv.exists(doc);
                }
            };
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return false;
        }

        @Override
        public boolean needsScores() {
            return false;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WrappedLongValuesSource that = (WrappedLongValuesSource)o;
            return Objects.equals(this.in, that.in);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.in);
        }

        @Override
        public String toString() {
            return this.in.toString();
        }

        @Override
        public LongValuesSource rewrite(IndexSearcher searcher) throws IOException {
            return this;
        }
    }

    private static class ScoreAndDoc
    extends Scorable {
        int current = -1;
        float score = 0.0f;

        private ScoreAndDoc() {
        }

        @Override
        public int docID() {
            return this.current;
        }

        @Override
        public float score() {
            return this.score;
        }
    }
}

