/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import javax.xml.namespace.QName;
import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.ValidationContext;
import org.apache.jena.ext.xerces.impl.dv.xs.TypeValidator;
import org.apache.jena.ext.xerces.util.XercesXMLChar;
import org.apache.jena.ext.xerces.xs.datatypes.XSQName;

public class QNameDV
extends TypeValidator {
    private static final String EMPTY_STRING = "".intern();

    @Override
    public short getAllowedFacets() {
        return 2079;
    }

    @Override
    public Object getActualValue(String content, ValidationContext context2) throws InvalidDatatypeValueException {
        String localpart;
        String prefix;
        int colonptr = content.indexOf(":");
        if (colonptr > 0) {
            prefix = context2.getSymbol(content.substring(0, colonptr));
            localpart = content.substring(colonptr + 1);
        } else {
            prefix = EMPTY_STRING;
            localpart = content;
        }
        if (prefix.length() > 0 && !XercesXMLChar.isValidNCName(prefix)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "QName"});
        }
        if (!XercesXMLChar.isValidNCName(localpart)) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "QName"});
        }
        String uri = context2.getURI(prefix);
        if (prefix.length() > 0 && uri == null) {
            throw new InvalidDatatypeValueException("UndeclaredPrefix", new Object[]{content, prefix});
        }
        return new XQName(prefix, context2.getSymbol(localpart), context2.getSymbol(content), uri);
    }

    @Override
    public int getDataLength(Object value) {
        return ((XQName)value).rawname.length();
    }

    private static final class XQName
    extends org.apache.jena.ext.xerces.xni.QName
    implements XSQName {
        public XQName(String prefix, String localpart, String rawname, String uri) {
            this.setValues(prefix, localpart, rawname, uri);
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof org.apache.jena.ext.xerces.xni.QName) {
                org.apache.jena.ext.xerces.xni.QName qname = (org.apache.jena.ext.xerces.xni.QName)object;
                return this.uri == qname.uri && this.localpart == qname.localpart;
            }
            return false;
        }

        @Override
        public String toString() {
            return this.rawname;
        }

        @Override
        public QName getJAXPQName() {
            return new QName(this.uri, this.localpart, this.prefix);
        }

        @Override
        public org.apache.jena.ext.xerces.xni.QName getXNIQName() {
            return this;
        }
    }
}

