/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.com.google.common.collect;

import java.util.Deque;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.apache.jena.ext.com.google.common.annotations.GwtIncompatible;
import org.apache.jena.ext.com.google.common.collect.ElementTypesAreNonnullByDefault;
import org.apache.jena.ext.com.google.common.collect.ForwardingQueue;
import org.apache.jena.ext.com.google.common.collect.ParametricNullness;
import org.apache.jena.ext.com.google.errorprone.annotations.CanIgnoreReturnValue;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ForwardingDeque<E>
extends ForwardingQueue<E>
implements Deque<E> {
    protected ForwardingDeque() {
    }

    @Override
    protected abstract Deque<E> delegate();

    @Override
    public void addFirst(@ParametricNullness E e2) {
        this.delegate().addFirst(e2);
    }

    @Override
    public void addLast(@ParametricNullness E e2) {
        this.delegate().addLast(e2);
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.delegate().descendingIterator();
    }

    @Override
    @ParametricNullness
    public E getFirst() {
        return this.delegate().getFirst();
    }

    @Override
    @ParametricNullness
    public E getLast() {
        return this.delegate().getLast();
    }

    @Override
    @CanIgnoreReturnValue
    public boolean offerFirst(@ParametricNullness E e2) {
        return this.delegate().offerFirst(e2);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean offerLast(@ParametricNullness E e2) {
        return this.delegate().offerLast(e2);
    }

    @Override
    @CheckForNull
    public E peekFirst() {
        return this.delegate().peekFirst();
    }

    @Override
    @CheckForNull
    public E peekLast() {
        return this.delegate().peekLast();
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public E pollFirst() {
        return this.delegate().pollFirst();
    }

    @Override
    @CheckForNull
    @CanIgnoreReturnValue
    public E pollLast() {
        return this.delegate().pollLast();
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public E pop() {
        return this.delegate().pop();
    }

    @Override
    public void push(@ParametricNullness E e2) {
        this.delegate().push(e2);
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public E removeFirst() {
        return this.delegate().removeFirst();
    }

    @Override
    @ParametricNullness
    @CanIgnoreReturnValue
    public E removeLast() {
        return this.delegate().removeLast();
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeFirstOccurrence(@CheckForNull Object o) {
        return this.delegate().removeFirstOccurrence(o);
    }

    @Override
    @CanIgnoreReturnValue
    public boolean removeLastOccurrence(@CheckForNull Object o) {
        return this.delegate().removeLastOccurrence(o);
    }
}

