/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.TermStates;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DisjunctionMatchesIterator;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.DocIdSetBuilder;
import org.apache.lucene.util.RamUsageEstimator;

final class MultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends Query
implements Accountable {
    private static final int BOOLEAN_REWRITE_TERM_COUNT_THRESHOLD = 16;
    protected final Q query;

    @Override
    public long ramBytesUsed() {
        if (this.query instanceof Accountable) {
            return (long)(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + ((Accountable)this.query).ramBytesUsed();
        }
        return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + RamUsageEstimator.NUM_BYTES_OBJECT_REF + 1024;
    }

    protected MultiTermQueryConstantScoreWrapper(Q query2) {
        this.query = query2;
    }

    @Override
    public String toString(String field) {
        return ((Query)this.query).toString(field);
    }

    @Override
    public final boolean equals(Object other) {
        return this.sameClassAs(other) && ((MultiTermQuery)this.query).equals(((MultiTermQueryConstantScoreWrapper)other).query);
    }

    @Override
    public final int hashCode() {
        return 31 * this.classHash() + ((MultiTermQuery)this.query).hashCode();
    }

    public Q getQuery() {
        return this.query;
    }

    public final String getField() {
        return ((MultiTermQuery)this.query).getField();
    }

    @Override
    public Weight createWeight(final IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, boost){

            private boolean collectTerms(LeafReaderContext context2, TermsEnum termsEnum, List<TermAndState> terms) throws IOException {
                int threshold = Math.min(16, BooleanQuery.getMaxClauseCount());
                for (int i = 0; i < threshold; ++i) {
                    BytesRef term = termsEnum.next();
                    if (term == null) {
                        return true;
                    }
                    TermState state = termsEnum.termState();
                    terms.add(new TermAndState(BytesRef.deepCopyOf(term), state, termsEnum.docFreq(), termsEnum.totalTermFreq()));
                }
                return termsEnum.next() == null;
            }

            private WeightOrDocIdSet rewrite(LeafReaderContext context2) throws IOException {
                Terms terms = context2.reader().terms(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field);
                if (terms == null) {
                    return new WeightOrDocIdSet((DocIdSet)null);
                }
                TermsEnum termsEnum = ((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).getTermsEnum(terms);
                assert (termsEnum != null);
                PostingsEnum docs = null;
                ArrayList<TermAndState> collectedTerms = new ArrayList<TermAndState>();
                if (this.collectTerms(context2, termsEnum, collectedTerms)) {
                    BooleanQuery.Builder bq = new BooleanQuery.Builder();
                    for (TermAndState t : collectedTerms) {
                        TermStates termStates = new TermStates(searcher.getTopReaderContext());
                        termStates.register(t.state, context2.ord, t.docFreq, t.totalTermFreq);
                        bq.add(new TermQuery(new Term(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field, t.term), termStates), BooleanClause.Occur.SHOULD);
                    }
                    ConstantScoreQuery q = new ConstantScoreQuery(bq.build());
                    Weight weight = searcher.rewrite(q).createWeight(searcher, scoreMode, this.score());
                    return new WeightOrDocIdSet(weight);
                }
                DocIdSetBuilder builder = new DocIdSetBuilder(context2.reader().maxDoc(), terms);
                if (!collectedTerms.isEmpty()) {
                    TermsEnum termsEnum2 = terms.iterator();
                    for (TermAndState t : collectedTerms) {
                        termsEnum2.seekExact(t.term, t.state);
                        docs = termsEnum2.postings(docs, 0);
                        builder.add(docs);
                    }
                }
                do {
                    docs = termsEnum.postings(docs, 0);
                    builder.add(docs);
                } while (termsEnum.next() != null);
                return new WeightOrDocIdSet(builder.build());
            }

            private Scorer scorer(DocIdSet set) throws IOException {
                if (set == null) {
                    return null;
                }
                DocIdSetIterator disi = set.iterator();
                if (disi == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, disi);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context2) throws IOException {
                WeightOrDocIdSet weightOrBitSet = this.rewrite(context2);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.bulkScorer(context2);
                }
                Scorer scorer = this.scorer(weightOrBitSet.set);
                if (scorer == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer(scorer);
            }

            @Override
            public Matches matches(LeafReaderContext context2, int doc) throws IOException {
                Terms terms = context2.reader().terms(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field);
                if (terms == null) {
                    return null;
                }
                if (!terms.hasPositions()) {
                    return super.matches(context2, doc);
                }
                return MatchesUtils.forField(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field, () -> DisjunctionMatchesIterator.fromTermsEnum(context2, doc, MultiTermQueryConstantScoreWrapper.this.query, ((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field, ((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).getTermsEnum(terms)));
            }

            @Override
            public Scorer scorer(LeafReaderContext context2) throws IOException {
                WeightOrDocIdSet weightOrBitSet = this.rewrite(context2);
                if (weightOrBitSet.weight != null) {
                    return weightOrBitSet.weight.scorer(context2);
                }
                return this.scorer(weightOrBitSet.set);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    @Override
    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.getField())) {
            ((Query)this.query).visit(visitor.getSubVisitor(BooleanClause.Occur.FILTER, this));
        }
    }

    private static class WeightOrDocIdSet {
        final Weight weight;
        final DocIdSet set;

        WeightOrDocIdSet(Weight weight) {
            this.weight = Objects.requireNonNull(weight);
            this.set = null;
        }

        WeightOrDocIdSet(DocIdSet bitset) {
            this.set = bitset;
            this.weight = null;
        }
    }

    private static class TermAndState {
        final BytesRef term;
        final TermState state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(BytesRef term, TermState state, int docFreq, long totalTermFreq) {
            this.term = term;
            this.state = state;
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }
    }
}

