/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.DocFreqValueSource;
import org.apache.lucene.search.IndexSearcher;

public class MaxDocValueSource
extends ValueSource {
    public String name() {
        return "maxdoc";
    }

    @Override
    public String description() {
        return this.name() + "()";
    }

    @Override
    public void createWeight(Map context2, IndexSearcher searcher) throws IOException {
        context2.put("searcher", searcher);
    }

    @Override
    public FunctionValues getValues(Map context2, LeafReaderContext readerContext) throws IOException {
        IndexSearcher searcher = (IndexSearcher)context2.get("searcher");
        return new DocFreqValueSource.ConstIntDocValues(searcher.getIndexReader().maxDoc(), this);
    }

    @Override
    public boolean equals(Object o) {
        return this.getClass() == o.getClass();
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

