/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.writers;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.path.P_Alt;
import org.apache.jena.sparql.path.P_Distinct;
import org.apache.jena.sparql.path.P_FixedLength;
import org.apache.jena.sparql.path.P_Inverse;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Mod;
import org.apache.jena.sparql.path.P_Multi;
import org.apache.jena.sparql.path.P_NegPropSet;
import org.apache.jena.sparql.path.P_OneOrMore1;
import org.apache.jena.sparql.path.P_OneOrMoreN;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.path.P_Path2;
import org.apache.jena.sparql.path.P_ReverseLink;
import org.apache.jena.sparql.path.P_Seq;
import org.apache.jena.sparql.path.P_Shortest;
import org.apache.jena.sparql.path.P_ZeroOrMore1;
import org.apache.jena.sparql.path.P_ZeroOrMoreN;
import org.apache.jena.sparql.path.P_ZeroOrOne;
import org.apache.jena.sparql.path.Path;
import org.apache.jena.sparql.path.PathVisitor;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.writers.WriterLib;
import org.apache.jena.sparql.sse.writers.WriterNode;

public class WriterPath {
    private static final int NL = 1;
    private static final int NoNL = -1;
    private static final int NoSP = -2;
    private static final boolean multiline = false;
    private static final boolean maxBracket = false;

    public static void write(Path path, Prologue prologue) {
        WriterPath.output(IndentedWriter.stdout, path, new SerializationContext(prologue));
    }

    public static void output(IndentedWriter out, Path path, SerializationContext naming) {
        WriterPathVisitor w = new WriterPathVisitor(out, naming);
        w.output(path);
        w.out.flush();
    }

    public static void output(IndentedWriter out, TriplePath tp, SerializationContext naming) {
        WriterLib.start(out, "path", -1);
        WriterPath.outputPlain(out, tp, naming);
        WriterLib.finish(out, "path");
    }

    public static void outputPlain(IndentedWriter out, TriplePath tp, SerializationContext naming) {
        boolean oneLiner = WriterPath.oneLiner(tp.getPath());
        if (oneLiner) {
            WriterNode.output(out, tp.getSubject(), naming);
            out.print(" ");
            WriterPath.output(out, tp.getPath(), naming);
            out.print(" ");
            WriterNode.output(out, tp.getObject(), naming);
        } else {
            WriterPath.nl(out, false);
            WriterNode.output(out, tp.getSubject(), naming);
            WriterPath.nl(out);
            WriterPath.output(out, tp.getPath(), naming);
            WriterPath.nl(out);
            WriterNode.output(out, tp.getObject(), naming);
        }
    }

    private static boolean oneLiner(Path path) {
        return path instanceof P_Link;
    }

    private static void nl(IndentedWriter out) {
        WriterPath.nl(out, true);
    }

    private static void nl(IndentedWriter out, boolean spaceForNL) {
        if (spaceForNL) {
            out.print(" ");
        }
    }

    public static String asString(Path path) {
        return WriterPath.asString(path, (SerializationContext)null);
    }

    @Deprecated
    public static String asString(Path path, Prologue prologue) {
        return WriterPath.asString(path, new SerializationContext(prologue));
    }

    public static String asString(Path path, SerializationContext sCxt) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        WriterPathVisitor w = new WriterPathVisitor(buff, sCxt);
        path.visit(w);
        w.out.flush();
        return buff.asString();
    }

    private static class WriterPathVisitor
    implements PathVisitor {
        private IndentedWriter out;
        private SerializationContext sCxt;

        WriterPathVisitor(IndentedWriter indentedWriter, SerializationContext sCxt) {
            this.out = indentedWriter;
            this.sCxt = sCxt;
        }

        private void output(Path path) {
            path.visit(this);
        }

        private void output(Node node) {
            WriterNode.output(this.out, node, this.sCxt);
        }

        @Override
        public void visit(P_Link pathNode) {
            this.output(pathNode.getNode());
        }

        @Override
        public void visit(P_ReverseLink pathNode) {
            this.out.print("(");
            this.out.print("rev");
            this.out.print(" ");
            this.output(pathNode.getNode());
            this.out.print(")");
        }

        @Override
        public void visit(P_NegPropSet pathNotOneOf) {
            this.out.print("(");
            this.out.print("notoneof");
            for (P_Path0 p : pathNotOneOf.getNodes()) {
                this.out.print(" ");
                this.output(p);
            }
            this.out.print(")");
        }

        @Override
        public void visit(P_Alt pathAlt) {
            this.visit2(pathAlt, "alt");
        }

        @Override
        public void visit(P_Seq pathSeq) {
            this.visit2(pathSeq, "seq");
        }

        private void visit2(P_Path2 path2, String nodeName) {
            this.out.print("(");
            this.out.print(nodeName);
            WriterPath.nl(this.out);
            this.out.incIndent();
            this.output(path2.getLeft());
            WriterPath.nl(this.out);
            this.output(path2.getRight());
            this.out.decIndent();
            this.out.print(")");
        }

        @Override
        public void visit(P_Mod pathMod) {
            this.out.print("(");
            this.out.print("mod");
            this.out.print(" ");
            this.out.print(WriterPathVisitor.modInt(pathMod.getMin()));
            this.out.print(" ");
            this.out.print(WriterPathVisitor.modInt(pathMod.getMax()));
            this.writeOneLiner(pathMod.getSubPath());
            this.out.print(")");
        }

        private static String modInt(long value) {
            if (value == -2L) {
                return "*";
            }
            if (value == -1L) {
                return "_";
            }
            return Long.toString(value);
        }

        @Override
        public void visit(P_FixedLength path) {
            this.out.print("(");
            this.out.print("pathN");
            this.out.print(" ");
            this.out.print(WriterPathVisitor.modInt(path.getCount()));
            this.writeOneLiner(path.getSubPath());
            this.out.print(")");
        }

        @Override
        public void visit(P_Distinct pathDistinct) {
            this.writePath("distinct", pathDistinct.getSubPath());
        }

        @Override
        public void visit(P_Multi pathMulti) {
            this.writePath("multi", pathMulti.getSubPath());
        }

        @Override
        public void visit(P_Shortest path) {
            this.writePath("shortest", path.getSubPath());
        }

        @Override
        public void visit(P_ZeroOrOne path) {
            this.writePath("path?", path.getSubPath());
        }

        @Override
        public void visit(P_ZeroOrMore1 path) {
            this.writePath("path*", path.getSubPath());
        }

        @Override
        public void visit(P_ZeroOrMoreN path) {
            this.writePath("pathN*", path.getSubPath());
        }

        @Override
        public void visit(P_OneOrMore1 path) {
            this.writePath("path+", path.getSubPath());
        }

        @Override
        public void visit(P_OneOrMoreN path) {
            this.writePath("pathN+", path.getSubPath());
        }

        private void writeOneLiner(Path path) {
            if (WriterPath.oneLiner(path)) {
                this.out.print(" ");
            } else {
                WriterPath.nl(this.out);
            }
            this.out.incIndent();
            this.output(path);
            this.out.decIndent();
        }

        private void writePath(String tag, Path subPath) {
            this.out.print("(");
            this.out.print(tag);
            this.writeOneLiner(subPath);
            this.out.print(")");
        }

        @Override
        public void visit(P_Inverse reversePath) {
            this.out.print("(");
            this.out.print("reverse");
            WriterPath.nl(this.out);
            this.out.incIndent();
            Path p = reversePath.getSubPath();
            this.output(p);
            this.out.decIndent();
            WriterPath.nl(this.out, false);
            this.out.print(")");
        }
    }
}

