/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset.rw;

import java.io.OutputStream;
import java.io.Writer;
import java.util.Objects;
import org.apache.jena.atlas.lib.NotImplemented;
import org.apache.jena.query.ResultSet;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriter;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.thrift.ThriftRDF;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.resultset.ResultSetException;
import org.apache.jena.sparql.util.Context;

public class ResultSetWriterThrift
implements ResultSetWriter {
    public static ResultSetWriterFactory factory = lang -> {
        if (!Objects.equals(lang, ResultSetLang.RS_Thrift)) {
            throw new ResultSetException("ResultSetWriter for RDF/Thift asked for a " + lang);
        }
        return new ResultSetWriterThrift();
    };

    @Override
    public void write(OutputStream out, ResultSet resultSet, Context context2) {
        ThriftRDF.writeRowSet(out, RowSet.adapt(resultSet));
    }

    @Override
    public void write(Writer out, ResultSet resultSet, Context context2) {
        throw new NotImplemented("Writing binary data to a java.io.Writer is not possible");
    }

    @Override
    public void write(OutputStream out, boolean result, Context context2) {
        throw new NotImplemented("No Thrift RDF encoding defined for boolean results");
    }
}

