/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;

public class GSPLib {
    public static boolean hasGSPParams(HttpAction action) {
        boolean hasParamGraph;
        boolean hasParamGraphDefault;
        if (action.getRequestQueryString() == null) {
            return false;
        }
        boolean bl = hasParamGraphDefault = action.getRequestParameter("default") != null;
        if (hasParamGraphDefault) {
            return true;
        }
        boolean bl2 = hasParamGraph = action.getRequestParameter("graph") != null;
        return hasParamGraph;
    }

    public static boolean hasGSPParamsStrict(HttpAction action) {
        if (action.getRequestQueryString() == null) {
            return false;
        }
        Map<String, String[]> params = action.getRequestParameterMap();
        if (params.size() != 1) {
            return false;
        }
        boolean hasParamGraphDefault = GSPLib.hasExactlyOneValue(action, "default");
        boolean hasParamGraph = GSPLib.hasExactlyOneValue(action, "graph");
        return hasParamGraph ^ hasParamGraphDefault;
    }

    public static boolean hasExactlyOneValue(HttpAction action, String name) {
        String[] values = action.getRequestParameterValues(name);
        if (values == null) {
            return false;
        }
        if (values.length == 0) {
            return false;
        }
        return values.length <= 1;
    }

    public static String getOneOnly(HttpServletRequest request, String name) {
        String[] values = request.getParameterValues(name);
        if (values == null) {
            return null;
        }
        if (values.length == 0) {
            return null;
        }
        if (values.length > 1) {
            ServletOps.errorBadRequest("Multiple occurrences of '" + name + "'");
        }
        return values[0];
    }
}

