/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.mgt;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.mgt.Template;
import org.apache.jena.riot.Lang;
import org.apache.jena.util.FileUtils;

public class TemplateFunctions {
    public static String templateFile(String templateName, Map<String, String> params, Lang lang) {
        String template;
        String templateFilename = Template.getPath(templateName).toString();
        try {
            template = FileUtils.readWholeFileAsUTF8(templateFilename);
        }
        catch (IOException ex) {
            Fuseki.serverLog.error("File not found: " + templateFilename);
            IO.exception(ex);
            return null;
        }
        return TemplateFunctions.templateString(template, params, lang);
    }

    public static String templateResource(String resourceName, Map<String, String> params, Lang lang) {
        String template;
        try {
            InputStream in = TemplateFunctions.class.getClassLoader().getResourceAsStream(resourceName);
            if (in == null) {
                Fuseki.serverLog.error("Resource not found: " + resourceName);
            }
            template = FileUtils.readWholeFileAsUTF8(in);
        }
        catch (IOException ex) {
            Fuseki.serverLog.error("Error reading resource: " + resourceName);
            IO.exception(ex);
            return null;
        }
        return TemplateFunctions.templateString(template, params, lang);
    }

    public static String templateString(String template, Map<String, String> params, Lang lang) {
        for (Map.Entry<String, String> e2 : params.entrySet()) {
            String x = e2.getValue();
            String k = "{" + e2.getKey() + "}";
            if (lang != null && (Lang.TTL.equals(lang) || Lang.TRIG.equals(lang) || Lang.NT.equals(lang) || Lang.NQ.equals(lang) || Lang.JSONLD.equals(lang) || Lang.RDFJSON.equals(lang))) {
                x = x.replace("\\", "\\\\");
                x = x.replace("\"", "\\\"");
            }
            template = template.replace(k, x);
        }
        return template;
    }
}

