/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.cmd;

import java.net.BindException;
import javax.servlet.ServletContext;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.jetty.FusekiErrorHandler;
import org.apache.jena.fuseki.jetty.JettyServerConfig;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.FusekiInfo;
import org.apache.jena.fuseki.webapp.FusekiEnv;
import org.eclipse.jetty.security.ConstraintMapping;
import org.eclipse.jetty.security.ConstraintSecurityHandler;
import org.eclipse.jetty.security.DefaultIdentityService;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.authentication.BasicAuthenticator;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Constraint;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlConfiguration;

public class JettyFusekiWebapp {
    public static JettyFusekiWebapp instance;
    private ServerConnector serverConnector = null;
    private ServerConnector mgtConnector = null;
    private JettyServerConfig serverConfig;
    private Server server = null;
    private ServletContext servletContext = null;
    public static String contextpath;
    public static final String resourceBase1 = "webapp";
    public static final String resourceBase2 = "target/webapp";

    public static void initializeServer(JettyServerConfig config) {
        instance = new JettyFusekiWebapp(config);
    }

    private JettyFusekiWebapp(JettyServerConfig config) {
        this.serverConfig = config;
        this.buildServerWebapp(this.serverConfig.contextPath, this.serverConfig.jettyConfigFile);
        if (this.mgtConnector == null) {
            this.mgtConnector = this.serverConnector;
        }
        if (config.enableCompression) {
            GzipHandler gzipHandler = new GzipHandler();
            gzipHandler.setHandler(this.server.getHandler());
            this.server.setHandler(gzipHandler);
        }
    }

    public void start() {
        FusekiInfo.server(Fuseki.serverLog);
        String host = this.serverConnector.getHost();
        if (host != null) {
            Fuseki.serverLog.info("Incoming connections limited to " + host);
        }
        try {
            this.server.start();
        }
        catch (BindException ex) {
            Fuseki.serverLog.error("SPARQLServer (port=" + this.serverConnector.getPort() + "): Failed to start server: " + ex.getMessage());
            throw new FusekiException("BindException: port=" + this.serverConnector.getPort() + ": Failed to start server: " + ex.getMessage(), ex);
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to start server: " + ex.getMessage(), ex);
            throw new FusekiException("Failed to start server: " + ex.getMessage(), ex);
        }
        String now2 = DateTimeUtils.nowAsString();
        Fuseki.serverLog.info(String.format("Started %s on port %d", now2, this.serverConnector.getPort()));
    }

    public void join() {
        try {
            this.server.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void stop() {
        String now2 = DateTimeUtils.nowAsString();
        Fuseki.serverLog.info(String.format("Stopped %s on port %d", now2, this.serverConnector.getPort()));
        try {
            this.server.stop();
        }
        catch (Exception ex) {
            Fuseki.serverLog.warn("SPARQLServer: Exception while stopping server: " + ex.getMessage(), ex);
        }
    }

    public static WebAppContext createWebApp(String contextPath) {
        FusekiEnv.setEnvironment();
        WebAppContext webapp = new WebAppContext();
        webapp.getServletContext().getContextHandler().setMaxFormContentSize(20000000);
        String resourceBase3 = null;
        String resourceBase4 = null;
        if (FusekiEnv.FUSEKI_HOME != null) {
            String HOME = FusekiEnv.FUSEKI_HOME.toString();
            resourceBase3 = HOME + "/webapp";
            resourceBase4 = HOME + "/target/webapp";
        }
        String resourceBase = JettyFusekiWebapp.tryResourceBase(resourceBase1, null);
        resourceBase = JettyFusekiWebapp.tryResourceBase(resourceBase2, resourceBase);
        resourceBase = JettyFusekiWebapp.tryResourceBase(resourceBase3, resourceBase);
        if ((resourceBase = JettyFusekiWebapp.tryResourceBase(resourceBase4, resourceBase)) == null) {
            if (resourceBase3 == null) {
                Fuseki.serverLog.error("Can't find resourceBase (tried webapp and target/webapp)");
            } else {
                Fuseki.serverLog.error("Can't find resourceBase (tried webapp, target/webapp, " + resourceBase3 + " and " + resourceBase4 + ")");
            }
            Fuseki.serverLog.error("Failed to start");
            throw new FusekiException("Failed to start");
        }
        webapp.setDescriptor(resourceBase + "/WEB-INF/web.xml");
        webapp.setResourceBase(resourceBase);
        webapp.setContextPath(contextPath);
        webapp.setDisplayName(Fuseki.servletRequestLogName);
        webapp.setParentLoaderPriority(true);
        webapp.setErrorHandler(new FusekiErrorHandler());
        return webapp;
    }

    public static String getenv(String name) {
        String x = System.getenv(name);
        if (x == null) {
            x = System.getProperty(name);
        }
        return x;
    }

    public DataAccessPointRegistry getDataAccessPointRegistry() {
        return DataAccessPointRegistry.get(this.servletContext);
    }

    private static String tryResourceBase(String maybeResourceBase, String currentResourceBase) {
        if (currentResourceBase != null) {
            return currentResourceBase;
        }
        if (maybeResourceBase != null && FileOps.exists(maybeResourceBase)) {
            return maybeResourceBase;
        }
        return currentResourceBase;
    }

    private void buildServerWebapp(String contextPath, String jettyConfig) {
        if (jettyConfig != null) {
            this.configServer(jettyConfig);
        } else {
            this.defaultServerConfig(this.serverConfig.port, this.serverConfig.loopback);
        }
        WebAppContext webapp = JettyFusekiWebapp.createWebApp(contextPath);
        this.servletContext = webapp.getServletContext();
        this.server.setHandler(webapp);
        if (jettyConfig == null && this.serverConfig.authConfigFile != null) {
            JettyFusekiWebapp.security(webapp, this.serverConfig.authConfigFile);
        }
    }

    private static void security(ServletContextHandler context2, String authfile) {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"fuseki"});
        constraint.setAuthenticate(true);
        ConstraintMapping mapping = new ConstraintMapping();
        mapping.setConstraint(constraint);
        mapping.setPathSpec("/*");
        DefaultIdentityService identService = new DefaultIdentityService();
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        securityHandler.addConstraintMapping(mapping);
        securityHandler.setIdentityService(identService);
        HashLoginService loginService = new HashLoginService("Fuseki Authentication", authfile);
        loginService.setIdentityService(identService);
        securityHandler.setLoginService(loginService);
        securityHandler.setAuthenticator(new BasicAuthenticator());
        context2.setSecurityHandler(securityHandler);
        Fuseki.serverLog.debug("Basic Auth Configuration = " + authfile);
    }

    private void configServer(String jettyConfig) {
        try {
            Fuseki.serverLog.info("Jetty server config file = " + jettyConfig);
            this.server = new Server();
            Resource configXml = Resource.newResource(jettyConfig);
            XmlConfiguration configuration = new XmlConfiguration(configXml);
            configuration.configure(this.server);
            this.serverConnector = (ServerConnector)this.server.getConnectors()[0];
        }
        catch (Exception ex) {
            Fuseki.serverLog.error("SPARQLServer: Failed to configure server: " + ex.getMessage(), ex);
            throw new FusekiException("Failed to configure a server using configuration file '" + jettyConfig + "'");
        }
    }

    private void defaultServerConfig(int port, boolean loopback) {
        this.server = new Server();
        HttpConnectionFactory f1 = new HttpConnectionFactory();
        f1.getHttpConfiguration().setRequestHeaderSize(524288);
        f1.getHttpConfiguration().setOutputBufferSize(0x500000);
        if (!Fuseki.outputJettyServerHeader) {
            f1.getHttpConfiguration().setSendServerVersion(false);
        }
        ServerConnector connector = new ServerConnector(this.server, f1);
        connector.setPort(port);
        this.server.addConnector(connector);
        if (loopback) {
            connector.setHost("localhost");
        }
        this.serverConnector = connector;
    }

    static {
        Fuseki.init();
        instance = null;
        contextpath = "/";
    }
}

