/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.auth;

import java.util.Queue;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.jena.fuseki.auth.AuthPolicy;

public class AuthPolicyList
implements AuthPolicy {
    private final Queue<AuthPolicy> policies = new ConcurrentLinkedQueue<AuthPolicy>();

    public static AuthPolicy merge(AuthPolicy policy1, AuthPolicy policy2) {
        if (policy1 == null) {
            return policy2;
        }
        if (policy2 == null) {
            return policy1;
        }
        if (policy1 instanceof AuthPolicyList) {
            AuthPolicyList x = new AuthPolicyList((AuthPolicyList)policy1);
            x.add(policy2);
            return x;
        }
        AuthPolicyList x = new AuthPolicyList();
        x.add(policy1);
        x.add(policy2);
        return x;
    }

    private AuthPolicyList(AuthPolicyList other) {
        this.policies.addAll(other.policies);
    }

    public AuthPolicyList() {
    }

    public void add(AuthPolicy policy) {
        this.policies.add(policy);
    }

    @Override
    public boolean isAllowed(String user) {
        for (AuthPolicy policy : this.policies) {
            if (policy.isAllowed(user)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringJoiner sj = new StringJoiner(", ", "(", ")");
        this.policies.stream().forEach(policy -> sj.add(policy.toString()));
        return sj.toString();
    }
}

