/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ext.xerces.impl.dv.xs;

import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.ext.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.jena.ext.xerces.impl.dv.ValidationContext;
import org.apache.jena.ext.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.jena.ext.xerces.impl.dv.xs.SchemaDateTimeException;

public class MonthDayDV
extends AbstractDateTimeDV {
    private static final int MONTHDAY_SIZE = 7;

    @Override
    public Object getActualValue(String content, ValidationContext context2) throws InvalidDatatypeValueException {
        try {
            return this.parse(content);
        }
        catch (Exception ex) {
            throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{content, "gMonthDay"});
        }
    }

    protected AbstractDateTimeDV.DateTimeData parse(String str2) throws SchemaDateTimeException {
        AbstractDateTimeDV.DateTimeData date2 = new AbstractDateTimeDV.DateTimeData(str2, this);
        int len = str2.length();
        date2.year = 2000;
        if (str2.charAt(0) != '-' || str2.charAt(1) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + str2);
        }
        date2.month = this.parseInt(str2, 2, 4);
        int start = 4;
        if (str2.charAt(start++) != '-') {
            throw new SchemaDateTimeException("Invalid format for gMonthDay: " + str2);
        }
        date2.day = this.parseInt(str2, start, start + 2);
        if (7 < len) {
            if (!this.isNextCharUTCSign(str2, 7, len)) {
                throw new SchemaDateTimeException("Error in month parsing:" + str2);
            }
            this.getTimeZone(str2, date2, 7, len);
        }
        this.validateDateTime(date2);
        this.saveUnnormalized(date2);
        if (date2.utc != 0 && date2.utc != 90) {
            this.normalize(date2);
        }
        date2.position = 1;
        return date2;
    }

    @Override
    protected String dateToString(AbstractDateTimeDV.DateTimeData date2) {
        StringBuffer message = new StringBuffer(8);
        message.append('-');
        message.append('-');
        this.append(message, date2.month, 2);
        message.append('-');
        this.append(message, date2.day, 2);
        this.append(message, (char)date2.utc, 0);
        return message.toString();
    }

    @Override
    protected XMLGregorianCalendar getXMLGregorianCalendar(AbstractDateTimeDV.DateTimeData date2) {
        return datatypeFactory.newXMLGregorianCalendar(Integer.MIN_VALUE, date2.unNormMonth, date2.unNormDay, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, date2.hasTimeZone() ? date2.timezoneHr * 60 + date2.timezoneMin : Integer.MIN_VALUE);
    }
}

