/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import org.apache.commons.lang3.Validate;

public class ClassPathUtils {
    public static String toFullyQualifiedName(Class<?> context2, String resourceName) {
        Validate.notNull(context2, "context", new Object[0]);
        Validate.notNull(resourceName, "resourceName", new Object[0]);
        return ClassPathUtils.toFullyQualifiedName(context2.getPackage(), resourceName);
    }

    public static String toFullyQualifiedName(Package context2, String resourceName) {
        Validate.notNull(context2, "context", new Object[0]);
        Validate.notNull(resourceName, "resourceName", new Object[0]);
        return context2.getName() + "." + resourceName;
    }

    public static String toFullyQualifiedPath(Class<?> context2, String resourceName) {
        Validate.notNull(context2, "context", new Object[0]);
        Validate.notNull(resourceName, "resourceName", new Object[0]);
        return ClassPathUtils.toFullyQualifiedPath(context2.getPackage(), resourceName);
    }

    public static String toFullyQualifiedPath(Package context2, String resourceName) {
        Validate.notNull(context2, "context", new Object[0]);
        Validate.notNull(resourceName, "resourceName", new Object[0]);
        return context2.getName().replace('.', '/') + "/" + resourceName;
    }
}

