/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.Part;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.LazyList;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.MultiPartInputStreamParser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@Deprecated
public class MultiPartFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(MultiPartFilter.class);
    public static final String CONTENT_TYPE_SUFFIX = ".org.eclipse.jetty.servlet.contentType";
    private static final String MULTIPART = "org.eclipse.jetty.servlet.MultiPartFile.multiPartInputStream";
    private File tempdir;
    private boolean _deleteFiles;
    private ServletContext _context;
    private int _fileOutputBuffer = 0;
    private boolean _writeFilesWithFilenames = false;
    private long _maxFileSize = -1L;
    private long _maxRequestSize = -1L;
    private int _maxFormKeys = Integer.getInteger("org.eclipse.jetty.server.Request.maxFormKeys", 1000);

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
        String maxRequestSize;
        String maxFileSize;
        this.tempdir = (File)filterConfig.getServletContext().getAttribute("javax.servlet.context.tempdir");
        this._deleteFiles = "true".equals(filterConfig.getInitParameter("deleteFiles"));
        String fileOutputBuffer = filterConfig.getInitParameter("fileOutputBuffer");
        if (fileOutputBuffer != null) {
            this._fileOutputBuffer = Integer.parseInt(fileOutputBuffer);
        }
        if ((maxFileSize = filterConfig.getInitParameter("maxFileSize")) != null) {
            this._maxFileSize = Long.parseLong(maxFileSize.trim());
        }
        if ((maxRequestSize = filterConfig.getInitParameter("maxRequestSize")) != null) {
            this._maxRequestSize = Long.parseLong(maxRequestSize.trim());
        }
        this._context = filterConfig.getServletContext();
        String mfks = filterConfig.getInitParameter("maxFormKeys");
        if (mfks != null) {
            this._maxFormKeys = Integer.parseInt(mfks);
        }
        this._writeFilesWithFilenames = "true".equalsIgnoreCase(filterConfig.getInitParameter("writeFilesWithFilenames"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest srequest = (HttpServletRequest)request;
        if (srequest.getContentType() == null || !srequest.getContentType().startsWith("multipart/form-data")) {
            chain.doFilter(request, response);
            return;
        }
        String contentType = srequest.getContentType();
        MultiMap<Object> params = new MultiMap<Object>();
        for (Map.Entry<String, String[]> entry : request.getParameterMap().entrySet()) {
            String[] value = entry.getValue();
            if (value instanceof String[]) {
                params.addValues(entry.getKey(), value);
                continue;
            }
            params.add(entry.getKey(), value);
        }
        MultipartConfigElement config = new MultipartConfigElement(this.tempdir.getCanonicalPath(), this._maxFileSize, this._maxRequestSize, this._fileOutputBuffer);
        MultiPartInputStreamParser mpis = new MultiPartInputStreamParser(request.getInputStream(), contentType, config, this.tempdir);
        mpis.setDeleteOnExit(this._deleteFiles);
        mpis.setWriteFilesWithFilenames(this._writeFilesWithFilenames);
        request.setAttribute(MULTIPART, mpis);
        try {
            Collection<Part> parts = mpis.getParts();
            if (parts != null) {
                Iterator<Part> itor = parts.iterator();
                while (itor.hasNext() && params.size() < this._maxFormKeys) {
                    MultiPartInputStreamParser.MultiPart mp;
                    Part p = itor.next();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}", p);
                    }
                    if ((mp = (MultiPartInputStreamParser.MultiPart)p).getFile() != null) {
                        request.setAttribute(mp.getName(), mp.getFile());
                        if (mp.getContentDispositionFilename() == null) continue;
                        params.add(mp.getName(), mp.getContentDispositionFilename());
                        if (mp.getContentType() == null) continue;
                        params.add(mp.getName() + CONTENT_TYPE_SUFFIX, mp.getContentType());
                        continue;
                    }
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    IO.copy(p.getInputStream(), bytes);
                    params.add(p.getName(), bytes.toByteArray());
                    if (p.getContentType() == null) continue;
                    params.add(p.getName() + CONTENT_TYPE_SUFFIX, p.getContentType());
                }
            }
            chain.doFilter(new Wrapper(srequest, params), response);
        }
        finally {
            this.deleteFiles(request);
        }
    }

    private void deleteFiles(ServletRequest request) {
        if (!this._deleteFiles) {
            return;
        }
        MultiPartInputStreamParser mpis = (MultiPartInputStreamParser)request.getAttribute(MULTIPART);
        if (mpis != null) {
            try {
                mpis.deleteParts();
            }
            catch (Exception e2) {
                this._context.log("Error deleting multipart tmp files", e2);
            }
        }
        request.removeAttribute(MULTIPART);
    }

    @Override
    public void destroy() {
    }

    private static class Wrapper
    extends HttpServletRequestWrapper {
        Charset _encoding = StandardCharsets.UTF_8;
        MultiMap<Object> _params;

        public Wrapper(HttpServletRequest request, MultiMap map) {
            super(request);
            this._params = map;
        }

        @Override
        public int getContentLength() {
            return 0;
        }

        @Override
        public String getParameter(String name) {
            Object o = this._params.get(name);
            if (!(o instanceof byte[]) && LazyList.size(o) > 0) {
                o = LazyList.get(o, 0);
            }
            if (o instanceof byte[]) {
                try {
                    return this.getParameterBytesAsString(name, (byte[])o);
                }
                catch (Exception e2) {
                    LOG.warn(e2);
                }
            } else if (o != null) {
                return String.valueOf(o);
            }
            return null;
        }

        @Override
        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> cmap = new HashMap<String, String[]>();
            for (Object key : this._params.keySet()) {
                cmap.put((String)key, this.getParameterValues((String)key));
            }
            return Collections.unmodifiableMap(cmap);
        }

        @Override
        public Enumeration<String> getParameterNames() {
            return Collections.enumeration(this._params.keySet());
        }

        @Override
        public String[] getParameterValues(String name) {
            List<Object> l = this._params.getValues(name);
            if (l == null || l.size() == 0) {
                return new String[0];
            }
            String[] v = new String[l.size()];
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                if (o instanceof byte[]) {
                    try {
                        v[i] = this.getParameterBytesAsString(name, (byte[])o);
                        continue;
                    }
                    catch (Exception e2) {
                        throw new RuntimeException(e2);
                    }
                }
                if (!(o instanceof String)) continue;
                v[i] = (String)o;
            }
            return v;
        }

        @Override
        public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
            try {
                this._encoding = Charset.forName(enc);
            }
            catch (UnsupportedCharsetException e2) {
                throw new UnsupportedEncodingException(e2.getMessage());
            }
        }

        private String getParameterBytesAsString(String name, byte[] bytes) throws UnsupportedEncodingException {
            Object ct = this._params.getValue(name + MultiPartFilter.CONTENT_TYPE_SUFFIX, 0);
            Charset contentType = this._encoding;
            if (ct != null) {
                String tmp = MimeTypes.getCharsetFromContentType((String)ct);
                try {
                    contentType = tmp == null ? this._encoding : Charset.forName(tmp);
                }
                catch (UnsupportedCharsetException e2) {
                    throw new UnsupportedEncodingException(e2.getMessage());
                }
            }
            return new String(bytes, contentType);
        }
    }
}

