/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.session;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.server.session.AbstractSessionDataStore;
import org.eclipse.jetty.server.session.DatabaseAdaptor;
import org.eclipse.jetty.server.session.SessionContext;
import org.eclipse.jetty.server.session.SessionData;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class JDBCSessionDataStore
extends AbstractSessionDataStore {
    static final Logger LOG = Log.getLogger("org.eclipse.jetty.server.session");
    public static final String NULL_CONTEXT_PATH = "/";
    protected boolean _initialized = false;
    protected DatabaseAdaptor _dbAdaptor;
    protected SessionTableSchema _sessionTableSchema;
    protected boolean _schemaProvided;
    private static final ByteArrayInputStream EMPTY = new ByteArrayInputStream(new byte[0]);

    @Override
    protected void doStart() throws Exception {
        if (this._dbAdaptor == null) {
            throw new IllegalStateException("No jdbc config");
        }
        this.initialize();
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._initialized = false;
        if (!this._schemaProvided) {
            this._sessionTableSchema = null;
        }
    }

    public void initialize() throws Exception {
        if (!this._initialized) {
            this._initialized = true;
            if (this._sessionTableSchema == null) {
                this._sessionTableSchema = new SessionTableSchema();
                this.addBean(this._sessionTableSchema, true);
            }
            this._dbAdaptor.initialize();
            this._sessionTableSchema.setDatabaseAdaptor(this._dbAdaptor);
            this._sessionTableSchema.prepareTables();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public SessionData doLoad(String id) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean delete(String id) throws Exception {
        try (Connection connection = this._dbAdaptor.getConnection();){
            boolean bl;
            block13: {
                PreparedStatement statement = this._sessionTableSchema.getDeleteStatement(connection, id, this._context);
                try {
                    connection.setAutoCommit(true);
                    int rows = statement.executeUpdate();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Deleted Session {}:{}", id, rows > 0);
                    }
                    boolean bl2 = bl = rows > 0;
                    if (statement == null) break block13;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
    }

    @Override
    public void doStore(String id, SessionData data, long lastSaveTime) throws Exception {
        if (data == null || id == null) {
            return;
        }
        if (lastSaveTime <= 0L) {
            this.doInsert(id, data);
        } else {
            this.doUpdate(id, data);
        }
    }

    protected void doInsert(String id, SessionData data) throws Exception {
        String s = this._sessionTableSchema.getInsertSessionStatementAsString();
        try (Connection connection = this._dbAdaptor.getConnection();){
            connection.setAutoCommit(true);
            try (PreparedStatement statement = connection.prepareStatement(s);){
                statement.setString(1, id);
                String cp = this._context.getCanonicalContextPath();
                if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank(cp)) {
                    cp = NULL_CONTEXT_PATH;
                }
                statement.setString(2, cp);
                statement.setString(3, this._context.getVhost());
                statement.setString(4, data.getLastNode());
                statement.setLong(5, data.getAccessed());
                statement.setLong(6, data.getLastAccessed());
                statement.setLong(7, data.getCreated());
                statement.setLong(8, data.getCookieSet());
                statement.setLong(9, data.getLastSaved());
                statement.setLong(10, data.getExpiry());
                statement.setLong(11, data.getMaxInactiveMs());
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                     ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    SessionData.serializeAttributes(data, oos);
                    byte[] bytes = baos.toByteArray();
                    ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
                    statement.setBinaryStream(12, (InputStream)bais, bytes.length);
                }
                statement.executeUpdate();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Inserted session " + data, new Object[0]);
                }
            }
        }
    }

    protected void doUpdate(String id, SessionData data) throws Exception {
        try (Connection connection = this._dbAdaptor.getConnection();){
            connection.setAutoCommit(true);
            try (PreparedStatement statement = this._sessionTableSchema.getUpdateSessionStatement(connection, data.getId(), this._context);){
                statement.setString(1, data.getLastNode());
                statement.setLong(2, data.getAccessed());
                statement.setLong(3, data.getLastAccessed());
                statement.setLong(4, data.getLastSaved());
                statement.setLong(5, data.getExpiry());
                statement.setLong(6, data.getMaxInactiveMs());
                try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                     ObjectOutputStream oos = new ObjectOutputStream(baos);){
                    SessionData.serializeAttributes(data, oos);
                    byte[] bytes = baos.toByteArray();
                    try (ByteArrayInputStream bais = new ByteArrayInputStream(bytes);){
                        statement.setBinaryStream(7, (InputStream)bais, bytes.length);
                    }
                }
                statement.executeUpdate();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updated session " + data, new Object[0]);
                }
            }
        }
    }

    @Override
    public Set<String> doGetExpired(Set<String> candidates) {
        HashSet<String> hashSet;
        block56: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Getting expired sessions at time {}", System.currentTimeMillis());
            }
            long now2 = System.currentTimeMillis();
            HashSet<String> expiredSessionKeys = new HashSet<String>();
            Connection connection = this._dbAdaptor.getConnection();
            try {
                String sessionId;
                Object result;
                connection.setAutoCommit(true);
                long upperBound = now2;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{}- Pass 1: Searching for sessions for context {} managed by me and expired before {}", this._context.getWorkerName(), this._context.getCanonicalContextPath(), upperBound);
                }
                try (PreparedStatement statement = this._sessionTableSchema.getExpiredSessionsStatement(connection, this._context.getCanonicalContextPath(), this._context.getVhost(), upperBound);){
                    result = statement.executeQuery();
                    try {
                        while (result.next()) {
                            sessionId = result.getString(this._sessionTableSchema.getIdColumn());
                            long exp = result.getLong(this._sessionTableSchema.getExpiryTimeColumn());
                            expiredSessionKeys.add(sessionId);
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug(this._context.getCanonicalContextPath() + "- Found expired sessionId=" + sessionId, new Object[0]);
                        }
                    }
                    finally {
                        if (result != null) {
                            result.close();
                        }
                    }
                }
                try (PreparedStatement selectExpiredSessions = this._sessionTableSchema.getAllAncientExpiredSessionsStatement(connection);){
                    upperBound = this._lastExpiryCheckTime <= 0L ? now2 - 3L * (1000L * (long)this._gracePeriodSec) : this._lastExpiryCheckTime - 1000L * (long)this._gracePeriodSec;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("{}- Pass 2: Searching for sessions expired before {}", this._context.getWorkerName(), upperBound);
                    }
                    selectExpiredSessions.setLong(1, upperBound);
                    result = selectExpiredSessions.executeQuery();
                    try {
                        while (result.next()) {
                            sessionId = result.getString(this._sessionTableSchema.getIdColumn());
                            String ctxtpth = result.getString(this._sessionTableSchema.getContextPathColumn());
                            String vh = result.getString(this._sessionTableSchema.getVirtualHostColumn());
                            expiredSessionKeys.add(sessionId);
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("{}- Found expired sessionId=", this._context.getWorkerName(), sessionId);
                        }
                    }
                    finally {
                        if (result != null) {
                            result.close();
                        }
                    }
                }
                HashSet<String> notExpiredInDB = new HashSet<String>();
                for (String k : candidates) {
                    if (expiredSessionKeys.contains(k)) continue;
                    notExpiredInDB.add(k);
                }
                if (!notExpiredInDB.isEmpty()) {
                    try (PreparedStatement checkSessionExists = this._sessionTableSchema.getCheckSessionExistsStatement(connection, this._context);){
                        for (String k : notExpiredInDB) {
                            checkSessionExists.setString(1, k);
                            try {
                                ResultSet result2 = checkSessionExists.executeQuery();
                                try {
                                    if (result2.next()) continue;
                                    expiredSessionKeys.add(k);
                                }
                                finally {
                                    if (result2 == null) continue;
                                    result2.close();
                                }
                            }
                            catch (Exception e2) {
                                LOG.warn("{} Problem checking if potentially expired session {} exists in db", this._context.getWorkerName(), k);
                                LOG.warn(e2);
                            }
                        }
                    }
                }
                hashSet = expiredSessionKeys;
                if (connection == null) break block56;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e3) {
                    LOG.warn(e3);
                    return expiredSessionKeys;
                }
            }
            connection.close();
        }
        return hashSet;
    }

    public void setDatabaseAdaptor(DatabaseAdaptor dbAdaptor) {
        this.checkStarted();
        this.updateBean(this._dbAdaptor, dbAdaptor);
        this._dbAdaptor = dbAdaptor;
    }

    public void setSessionTableSchema(SessionTableSchema schema) {
        this.checkStarted();
        this.updateBean(this._sessionTableSchema, schema);
        this._sessionTableSchema = schema;
        this._schemaProvided = true;
    }

    @Override
    @ManagedAttribute(value="does this store serialize sessions", readonly=true)
    public boolean isPassivating() {
        return true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean exists(String id) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static class SessionTableSchema {
        public static final int MAX_INTERVAL_NOT_SET = -999;
        public static final String INFERRED = "INFERRED";
        protected DatabaseAdaptor _dbAdaptor;
        protected String _schemaName = null;
        protected String _catalogName = null;
        protected String _tableName = "JettySessions";
        protected String _idColumn = "sessionId";
        protected String _contextPathColumn = "contextPath";
        protected String _virtualHostColumn = "virtualHost";
        protected String _lastNodeColumn = "lastNode";
        protected String _accessTimeColumn = "accessTime";
        protected String _lastAccessTimeColumn = "lastAccessTime";
        protected String _createTimeColumn = "createTime";
        protected String _cookieTimeColumn = "cookieTime";
        protected String _lastSavedTimeColumn = "lastSavedTime";
        protected String _expiryTimeColumn = "expiryTime";
        protected String _maxIntervalColumn = "maxInterval";
        protected String _mapColumn = "map";

        protected void setDatabaseAdaptor(DatabaseAdaptor dbadaptor) {
            this._dbAdaptor = dbadaptor;
        }

        public void setCatalogName(String catalogName) {
            this._catalogName = catalogName != null && StringUtil.isBlank(catalogName) ? null : catalogName;
        }

        public String getCatalogName() {
            return this._catalogName;
        }

        public String getSchemaName() {
            return this._schemaName;
        }

        public void setSchemaName(String schemaName) {
            this._schemaName = schemaName != null && StringUtil.isBlank(schemaName) ? null : schemaName;
        }

        public String getTableName() {
            return this._tableName;
        }

        public void setTableName(String tableName) {
            this.checkNotNull(tableName);
            this._tableName = tableName;
        }

        private String getSchemaTableName() {
            return (this.getSchemaName() != null ? this.getSchemaName() + "." : "") + this.getTableName();
        }

        public String getIdColumn() {
            return this._idColumn;
        }

        public void setIdColumn(String idColumn) {
            this.checkNotNull(idColumn);
            this._idColumn = idColumn;
        }

        public String getContextPathColumn() {
            return this._contextPathColumn;
        }

        public void setContextPathColumn(String contextPathColumn) {
            this.checkNotNull(contextPathColumn);
            this._contextPathColumn = contextPathColumn;
        }

        public String getVirtualHostColumn() {
            return this._virtualHostColumn;
        }

        public void setVirtualHostColumn(String virtualHostColumn) {
            this.checkNotNull(virtualHostColumn);
            this._virtualHostColumn = virtualHostColumn;
        }

        public String getLastNodeColumn() {
            return this._lastNodeColumn;
        }

        public void setLastNodeColumn(String lastNodeColumn) {
            this.checkNotNull(lastNodeColumn);
            this._lastNodeColumn = lastNodeColumn;
        }

        public String getAccessTimeColumn() {
            return this._accessTimeColumn;
        }

        public void setAccessTimeColumn(String accessTimeColumn) {
            this.checkNotNull(accessTimeColumn);
            this._accessTimeColumn = accessTimeColumn;
        }

        public String getLastAccessTimeColumn() {
            return this._lastAccessTimeColumn;
        }

        public void setLastAccessTimeColumn(String lastAccessTimeColumn) {
            this.checkNotNull(lastAccessTimeColumn);
            this._lastAccessTimeColumn = lastAccessTimeColumn;
        }

        public String getCreateTimeColumn() {
            return this._createTimeColumn;
        }

        public void setCreateTimeColumn(String createTimeColumn) {
            this.checkNotNull(createTimeColumn);
            this._createTimeColumn = createTimeColumn;
        }

        public String getCookieTimeColumn() {
            return this._cookieTimeColumn;
        }

        public void setCookieTimeColumn(String cookieTimeColumn) {
            this.checkNotNull(cookieTimeColumn);
            this._cookieTimeColumn = cookieTimeColumn;
        }

        public String getLastSavedTimeColumn() {
            return this._lastSavedTimeColumn;
        }

        public void setLastSavedTimeColumn(String lastSavedTimeColumn) {
            this.checkNotNull(lastSavedTimeColumn);
            this._lastSavedTimeColumn = lastSavedTimeColumn;
        }

        public String getExpiryTimeColumn() {
            return this._expiryTimeColumn;
        }

        public void setExpiryTimeColumn(String expiryTimeColumn) {
            this.checkNotNull(expiryTimeColumn);
            this._expiryTimeColumn = expiryTimeColumn;
        }

        public String getMaxIntervalColumn() {
            return this._maxIntervalColumn;
        }

        public void setMaxIntervalColumn(String maxIntervalColumn) {
            this.checkNotNull(maxIntervalColumn);
            this._maxIntervalColumn = maxIntervalColumn;
        }

        public String getMapColumn() {
            return this._mapColumn;
        }

        public void setMapColumn(String mapColumn) {
            this.checkNotNull(mapColumn);
            this._mapColumn = mapColumn;
        }

        public String getCreateStatementAsString() {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DBAdaptor");
            }
            String blobType = this._dbAdaptor.getBlobType();
            String longType = this._dbAdaptor.getLongType();
            String stringType = this._dbAdaptor.getStringType();
            return "create table " + this._tableName + " (" + this._idColumn + " " + stringType + "(120), " + this._contextPathColumn + " " + stringType + "(60), " + this._virtualHostColumn + " " + stringType + "(60), " + this._lastNodeColumn + " " + stringType + "(60), " + this._accessTimeColumn + " " + longType + ", " + this._lastAccessTimeColumn + " " + longType + ", " + this._createTimeColumn + " " + longType + ", " + this._cookieTimeColumn + " " + longType + ", " + this._lastSavedTimeColumn + " " + longType + ", " + this._expiryTimeColumn + " " + longType + ", " + this._maxIntervalColumn + " " + longType + ", " + this._mapColumn + " " + blobType + ", primary key(" + this._idColumn + ", " + this._contextPathColumn + "," + this._virtualHostColumn + "))";
        }

        public String getCreateIndexOverExpiryStatementAsString(String indexName) {
            return "create index " + indexName + " on " + this.getSchemaTableName() + " (" + this.getExpiryTimeColumn() + ")";
        }

        public String getCreateIndexOverSessionStatementAsString(String indexName) {
            return "create index " + indexName + " on " + this.getSchemaTableName() + " (" + this.getIdColumn() + ", " + this.getContextPathColumn() + ")";
        }

        public String getAlterTableForMaxIntervalAsString() {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DBAdaptor");
            }
            String longType = this._dbAdaptor.getLongType();
            String stem = "alter table " + this.getSchemaTableName() + " add " + this.getMaxIntervalColumn() + " " + longType;
            if (this._dbAdaptor.getDBName().contains("oracle")) {
                return stem + " default " + -999 + " not null";
            }
            return stem + " not null default " + -999;
        }

        private void checkNotNull(String s) {
            if (s == null) {
                throw new IllegalArgumentException(s);
            }
        }

        public String getInsertSessionStatementAsString() {
            return "insert into " + this.getSchemaTableName() + " (" + this.getIdColumn() + ", " + this.getContextPathColumn() + ", " + this.getVirtualHostColumn() + ", " + this.getLastNodeColumn() + ", " + this.getAccessTimeColumn() + ", " + this.getLastAccessTimeColumn() + ", " + this.getCreateTimeColumn() + ", " + this.getCookieTimeColumn() + ", " + this.getLastSavedTimeColumn() + ", " + this.getExpiryTimeColumn() + ", " + this.getMaxIntervalColumn() + ", " + this.getMapColumn() + ")  values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        }

        public PreparedStatement getUpdateSessionStatement(Connection connection, String id, SessionContext context2) throws SQLException {
            String s = "update " + this.getSchemaTableName() + " set " + this.getLastNodeColumn() + " = ?, " + this.getAccessTimeColumn() + " = ?, " + this.getLastAccessTimeColumn() + " = ?, " + this.getLastSavedTimeColumn() + " = ?, " + this.getExpiryTimeColumn() + " = ?, " + this.getMaxIntervalColumn() + " = ?, " + this.getMapColumn() + " = ? where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?";
            String cp = context2.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank(cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement(s);
            statement.setString(8, id);
            statement.setString(9, cp);
            statement.setString(10, context2.getVhost());
            return statement;
        }

        public PreparedStatement getExpiredSessionsStatement(Connection connection, String canonicalContextPath, String vhost, long expiry) throws SQLException {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = canonicalContextPath;
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank(cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("select " + this.getIdColumn() + ", " + this.getExpiryTimeColumn() + " from " + this.getSchemaTableName() + " where " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ? and " + this.getExpiryTimeColumn() + " >0 and " + this.getExpiryTimeColumn() + " <= ?");
            statement.setString(1, cp);
            statement.setString(2, vhost);
            statement.setLong(3, expiry);
            return statement;
        }

        public PreparedStatement getMyExpiredSessionsStatement(Connection connection, SessionContext sessionContext, long expiry) throws SQLException {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = sessionContext.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank(cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("select " + this.getIdColumn() + ", " + this.getExpiryTimeColumn() + " from " + this.getSchemaTableName() + " where " + this.getLastNodeColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ? and " + this.getExpiryTimeColumn() + " >0 and " + this.getExpiryTimeColumn() + " <= ?");
            statement.setString(1, sessionContext.getWorkerName());
            statement.setString(2, cp);
            statement.setString(3, sessionContext.getVhost());
            statement.setLong(4, expiry);
            return statement;
        }

        public PreparedStatement getAllAncientExpiredSessionsStatement(Connection connection) throws SQLException {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            PreparedStatement statement = connection.prepareStatement("select " + this.getIdColumn() + ", " + this.getContextPathColumn() + ", " + this.getVirtualHostColumn() + " from " + this.getSchemaTableName() + " where " + this.getExpiryTimeColumn() + " >0 and " + this.getExpiryTimeColumn() + " <= ?");
            return statement;
        }

        public PreparedStatement getCheckSessionExistsStatement(Connection connection, SessionContext context2) throws SQLException {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = context2.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank(cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("select " + this.getIdColumn() + ", " + this.getExpiryTimeColumn() + " from " + this.getSchemaTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?");
            statement.setString(2, cp);
            statement.setString(3, context2.getVhost());
            return statement;
        }

        public PreparedStatement getLoadStatement(Connection connection, String id, SessionContext contextId) throws SQLException {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = contextId.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank(cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("select * from " + this.getSchemaTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?");
            statement.setString(1, id);
            statement.setString(2, cp);
            statement.setString(3, contextId.getVhost());
            return statement;
        }

        public PreparedStatement getUpdateStatement(Connection connection, String id, SessionContext contextId) throws SQLException {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = contextId.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank(cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            String s = "update " + this.getSchemaTableName() + " set " + this.getLastNodeColumn() + " = ?, " + this.getAccessTimeColumn() + " = ?, " + this.getLastAccessTimeColumn() + " = ?, " + this.getLastSavedTimeColumn() + " = ?, " + this.getExpiryTimeColumn() + " = ?, " + this.getMaxIntervalColumn() + " = ?, " + this.getMapColumn() + " = ? where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?";
            PreparedStatement statement = connection.prepareStatement(s);
            statement.setString(8, id);
            statement.setString(9, cp);
            statement.setString(10, contextId.getVhost());
            return statement;
        }

        public PreparedStatement getDeleteStatement(Connection connection, String id, SessionContext contextId) throws Exception {
            if (this._dbAdaptor == null) {
                throw new IllegalStateException("No DB adaptor");
            }
            String cp = contextId.getCanonicalContextPath();
            if (this._dbAdaptor.isEmptyStringNull() && StringUtil.isBlank(cp)) {
                cp = JDBCSessionDataStore.NULL_CONTEXT_PATH;
            }
            PreparedStatement statement = connection.prepareStatement("delete from " + this.getSchemaTableName() + " where " + this.getIdColumn() + " = ? and " + this.getContextPathColumn() + " = ? and " + this.getVirtualHostColumn() + " = ?");
            statement.setString(1, id);
            statement.setString(2, cp);
            statement.setString(3, contextId.getVhost());
            return statement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void prepareTables() throws SQLException {
            try (Connection connection = this._dbAdaptor.getConnection();
                 Statement statement = connection.createStatement();){
                String catalogName;
                String schemaName;
                String tableName;
                DatabaseMetaData metaData;
                block40: {
                    connection.setAutoCommit(true);
                    metaData = connection.getMetaData();
                    this._dbAdaptor.adaptTo(metaData);
                    tableName = this._dbAdaptor.convertIdentifier(this.getTableName());
                    schemaName = this._dbAdaptor.convertIdentifier(this.getSchemaName());
                    if (INFERRED.equalsIgnoreCase(schemaName)) {
                        schemaName = connection.getSchema();
                        this.setSchemaName(schemaName);
                    }
                    if (INFERRED.equalsIgnoreCase(catalogName = this._dbAdaptor.convertIdentifier(this.getCatalogName()))) {
                        catalogName = connection.getCatalog();
                        this.setCatalogName(catalogName);
                    }
                    try (ResultSet result = metaData.getTables(catalogName, schemaName, tableName, null);){
                        if (!result.next()) {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("Creating table {} schema={} catalog={}", tableName, schemaName, catalogName);
                            }
                            statement.executeUpdate(this.getCreateStatementAsString());
                            break block40;
                        }
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Not creating table {} schema={} catalog={}", tableName, schemaName, catalogName);
                        }
                        ResultSet colResult = null;
                        try {
                            colResult = metaData.getColumns(catalogName, schemaName, tableName, this._dbAdaptor.convertIdentifier(this.getMaxIntervalColumn()));
                        }
                        catch (SQLException sqlEx) {
                            LOG.warn("Problem checking if {} table contains {} column. Ensure table contains column with definition: long not null default -999", this.getTableName(), this.getMaxIntervalColumn());
                            throw sqlEx;
                        }
                        try {
                            if (colResult.next()) break block40;
                            try {
                                statement.executeUpdate(this.getAlterTableForMaxIntervalAsString());
                            }
                            catch (SQLException sqlEx) {
                                LOG.warn("Problem adding {} column. Ensure table contains column definition: long not null default -999", this.getMaxIntervalColumn());
                                throw sqlEx;
                            }
                        }
                        finally {
                            colResult.close();
                        }
                    }
                }
                String index1 = "idx_" + this.getTableName() + "_expiry";
                String index2 = "idx_" + this.getTableName() + "_session";
                boolean index1Exists = false;
                boolean index2Exists = false;
                try (ResultSet result = metaData.getIndexInfo(catalogName, schemaName, tableName, false, true);){
                    while (result.next()) {
                        String idxName = result.getString("INDEX_NAME");
                        if (index1.equalsIgnoreCase(idxName)) {
                            index1Exists = true;
                            continue;
                        }
                        if (!index2.equalsIgnoreCase(idxName)) continue;
                        index2Exists = true;
                    }
                }
                if (!index1Exists) {
                    statement.executeUpdate(this.getCreateIndexOverExpiryStatementAsString(index1));
                }
                if (!index2Exists) {
                    statement.executeUpdate(this.getCreateIndexOverSessionStatementAsString(index2));
                }
            }
        }

        public String toString() {
            return String.format("%s[%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s]", super.toString(), this._catalogName, this._schemaName, this._tableName, this._idColumn, this._contextPathColumn, this._virtualHostColumn, this._cookieTimeColumn, this._createTimeColumn, this._expiryTimeColumn, this._accessTimeColumn, this._lastAccessTimeColumn, this._lastNodeColumn, this._lastSavedTimeColumn, this._maxIntervalColumn);
        }
    }
}

