/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsReader;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.Compressor;
import org.apache.lucene.codecs.compressing.FieldsIndex;
import org.apache.lucene.codecs.compressing.FieldsIndexWriter;
import org.apache.lucene.codecs.compressing.MatchingReaders;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocIDMerger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingStoredFieldsWriter
extends StoredFieldsWriter {
    public static final String FIELDS_EXTENSION = "fdt";
    public static final String INDEX_EXTENSION = "fdx";
    public static final String META_EXTENSION = "fdm";
    public static final String INDEX_CODEC_NAME = "Lucene85FieldsIndex";
    static final int STRING = 0;
    static final int BYTE_ARR = 1;
    static final int NUMERIC_INT = 2;
    static final int NUMERIC_FLOAT = 3;
    static final int NUMERIC_LONG = 4;
    static final int NUMERIC_DOUBLE = 5;
    static final int TYPE_BITS = PackedInts.bitsRequired(5L);
    static final int TYPE_MASK = (int)PackedInts.maxValue(TYPE_BITS);
    static final int VERSION_START = 1;
    static final int VERSION_OFFHEAP_INDEX = 2;
    static final int VERSION_META = 3;
    static final int VERSION_CURRENT = 3;
    static final int META_VERSION_START = 0;
    private final String segment;
    private FieldsIndexWriter indexWriter;
    private IndexOutput metaStream;
    private IndexOutput fieldsStream;
    private Compressor compressor;
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int maxDocsPerChunk;
    private final ByteBuffersDataOutput bufferedDocs;
    private int[] numStoredFields;
    private int[] endOffsets;
    private int docBase;
    private int numBufferedDocs;
    private long numDirtyChunks;
    private long numDirtyDocs;
    private int numStoredFieldsInDoc;
    static final int NEGATIVE_ZERO_FLOAT = Float.floatToIntBits(-0.0f);
    static final long NEGATIVE_ZERO_DOUBLE = Double.doubleToLongBits(-0.0);
    static final long SECOND = 1000L;
    static final long HOUR = 3600000L;
    static final long DAY = 86400000L;
    static final int SECOND_ENCODING = 64;
    static final int HOUR_ENCODING = 128;
    static final int DAY_ENCODING = 192;
    static final String BULK_MERGE_ENABLED_SYSPROP = CompressingStoredFieldsWriter.class.getName() + ".enableBulkMerge";
    static final boolean BULK_MERGE_ENABLED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    CompressingStoredFieldsWriter(Directory directory, SegmentInfo si, String segmentSuffix, IOContext context2, String formatName, CompressionMode compressionMode, int chunkSize, int maxDocsPerChunk, int blockShift) throws IOException {
        assert (directory != null);
        this.segment = si.name;
        this.compressionMode = compressionMode;
        this.compressor = compressionMode.newCompressor();
        this.chunkSize = chunkSize;
        this.maxDocsPerChunk = maxDocsPerChunk;
        this.docBase = 0;
        this.bufferedDocs = ByteBuffersDataOutput.newResettableInstance();
        this.numStoredFields = new int[16];
        this.endOffsets = new int[16];
        this.numBufferedDocs = 0;
        boolean success = false;
        try {
            this.metaStream = directory.createOutput(IndexFileNames.segmentFileName(this.segment, segmentSuffix, META_EXTENSION), context2);
            CodecUtil.writeIndexHeader(this.metaStream, "Lucene85FieldsIndexMeta", 3, si.getId(), segmentSuffix);
            assert ((long)CodecUtil.indexHeaderLength("Lucene85FieldsIndexMeta", segmentSuffix) == this.metaStream.getFilePointer());
            this.fieldsStream = directory.createOutput(IndexFileNames.segmentFileName(this.segment, segmentSuffix, FIELDS_EXTENSION), context2);
            CodecUtil.writeIndexHeader(this.fieldsStream, formatName, 3, si.getId(), segmentSuffix);
            assert ((long)CodecUtil.indexHeaderLength(formatName, segmentSuffix) == this.fieldsStream.getFilePointer());
            this.indexWriter = new FieldsIndexWriter(directory, this.segment, segmentSuffix, INDEX_EXTENSION, INDEX_CODEC_NAME, si.getId(), blockShift, context2);
            this.metaStream.writeVInt(chunkSize);
            this.metaStream.writeVInt(2);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this.metaStream, this.fieldsStream, this.indexWriter);
            throw throwable;
        }
    }

    @Override
    public void close() throws IOException {
        try {
            IOUtils.close(this.metaStream, this.fieldsStream, this.indexWriter, this.compressor);
        }
        finally {
            this.metaStream = null;
            this.fieldsStream = null;
            this.indexWriter = null;
            this.compressor = null;
        }
    }

    @Override
    public void startDocument() throws IOException {
    }

    @Override
    public void finishDocument() throws IOException {
        if (this.numBufferedDocs == this.numStoredFields.length) {
            int newLength = ArrayUtil.oversize(this.numBufferedDocs + 1, 4);
            this.numStoredFields = ArrayUtil.growExact(this.numStoredFields, newLength);
            this.endOffsets = ArrayUtil.growExact(this.endOffsets, newLength);
        }
        this.numStoredFields[this.numBufferedDocs] = this.numStoredFieldsInDoc;
        this.numStoredFieldsInDoc = 0;
        this.endOffsets[this.numBufferedDocs] = Math.toIntExact(this.bufferedDocs.size());
        ++this.numBufferedDocs;
        if (this.triggerFlush()) {
            this.flush();
        }
    }

    private static void saveInts(int[] values, int length, DataOutput out) throws IOException {
        assert (length > 0);
        if (length == 1) {
            out.writeVInt(values[0]);
        } else {
            boolean allEqual = true;
            for (int i = 1; i < length; ++i) {
                if (values[i] == values[0]) continue;
                allEqual = false;
                break;
            }
            if (allEqual) {
                out.writeVInt(0);
                out.writeVInt(values[0]);
            } else {
                long max2 = 0L;
                for (int i = 0; i < length; ++i) {
                    max2 |= (long)values[i];
                }
                int bitsRequired = PackedInts.bitsRequired(max2);
                out.writeVInt(bitsRequired);
                PackedInts.Writer w = PackedInts.getWriterNoHeader(out, PackedInts.Format.PACKED, length, bitsRequired, 1);
                for (int i = 0; i < length; ++i) {
                    w.add(values[i]);
                }
                w.finish();
            }
        }
    }

    private void writeHeader(int docBase, int numBufferedDocs, int[] numStoredFields, int[] lengths, boolean sliced) throws IOException {
        int slicedBit = sliced ? 1 : 0;
        this.fieldsStream.writeVInt(docBase);
        this.fieldsStream.writeVInt(numBufferedDocs << 1 | slicedBit);
        CompressingStoredFieldsWriter.saveInts(numStoredFields, numBufferedDocs, this.fieldsStream);
        CompressingStoredFieldsWriter.saveInts(lengths, numBufferedDocs, this.fieldsStream);
    }

    private boolean triggerFlush() {
        return this.bufferedDocs.size() >= (long)this.chunkSize || this.numBufferedDocs >= this.maxDocsPerChunk;
    }

    private void flush() throws IOException {
        this.indexWriter.writeIndex(this.numBufferedDocs, this.fieldsStream.getFilePointer());
        int[] lengths = this.endOffsets;
        for (int i = this.numBufferedDocs - 1; i > 0; --i) {
            lengths[i] = this.endOffsets[i] - this.endOffsets[i - 1];
            assert (lengths[i] >= 0);
        }
        boolean sliced = this.bufferedDocs.size() >= (long)(2 * this.chunkSize);
        this.writeHeader(this.docBase, this.numBufferedDocs, this.numStoredFields, lengths, sliced);
        byte[] content = this.bufferedDocs.toArrayCopy();
        this.bufferedDocs.reset();
        if (sliced) {
            for (int compressed = 0; compressed < content.length; compressed += this.chunkSize) {
                this.compressor.compress(content, compressed, Math.min(this.chunkSize, content.length - compressed), this.fieldsStream);
            }
        } else {
            this.compressor.compress(content, 0, content.length, this.fieldsStream);
        }
        this.docBase += this.numBufferedDocs;
        this.numBufferedDocs = 0;
        this.bufferedDocs.reset();
    }

    @Override
    public void writeField(FieldInfo info, IndexableField field) throws IOException {
        BytesRef bytes;
        String string;
        ++this.numStoredFieldsInDoc;
        int bits = 0;
        Number number = field.numericValue();
        if (number != null) {
            if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
                bits = 2;
            } else if (number instanceof Long) {
                bits = 4;
            } else if (number instanceof Float) {
                bits = 3;
            } else if (number instanceof Double) {
                bits = 5;
            } else {
                throw new IllegalArgumentException("cannot store numeric type " + number.getClass());
            }
            string = null;
            bytes = null;
        } else {
            bytes = field.binaryValue();
            if (bytes != null) {
                bits = 1;
                string = null;
            } else {
                bits = 0;
                string = field.stringValue();
                if (string == null) {
                    throw new IllegalArgumentException("field " + field.name() + " is stored but does not have binaryValue, stringValue nor numericValue");
                }
            }
        }
        long infoAndBits = (long)info.number << TYPE_BITS | (long)bits;
        this.bufferedDocs.writeVLong(infoAndBits);
        if (bytes != null) {
            this.bufferedDocs.writeVInt(bytes.length);
            this.bufferedDocs.writeBytes(bytes.bytes, bytes.offset, bytes.length);
        } else if (string != null) {
            this.bufferedDocs.writeString(string);
        } else if (number instanceof Byte || number instanceof Short || number instanceof Integer) {
            this.bufferedDocs.writeZInt(number.intValue());
        } else if (number instanceof Long) {
            CompressingStoredFieldsWriter.writeTLong(this.bufferedDocs, number.longValue());
        } else if (number instanceof Float) {
            CompressingStoredFieldsWriter.writeZFloat(this.bufferedDocs, number.floatValue());
        } else if (number instanceof Double) {
            CompressingStoredFieldsWriter.writeZDouble(this.bufferedDocs, number.doubleValue());
        } else {
            throw new AssertionError((Object)"Cannot get here");
        }
    }

    static void writeZFloat(DataOutput out, float f) throws IOException {
        int intVal = (int)f;
        int floatBits = Float.floatToIntBits(f);
        if (f == (float)intVal && intVal >= -1 && intVal <= 125 && floatBits != NEGATIVE_ZERO_FLOAT) {
            out.writeByte((byte)(0x80 | 1 + intVal));
        } else if (floatBits >>> 31 == 0) {
            out.writeInt(floatBits);
        } else {
            out.writeByte((byte)-1);
            out.writeInt(floatBits);
        }
    }

    static void writeZDouble(DataOutput out, double d) throws IOException {
        int intVal = (int)d;
        long doubleBits = Double.doubleToLongBits(d);
        if (d == (double)intVal && intVal >= -1 && intVal <= 124 && doubleBits != NEGATIVE_ZERO_DOUBLE) {
            out.writeByte((byte)(0x80 | intVal + 1));
            return;
        }
        if (d == (double)((float)d)) {
            out.writeByte((byte)-2);
            out.writeInt(Float.floatToIntBits((float)d));
        } else if (doubleBits >>> 63 == 0L) {
            out.writeLong(doubleBits);
        } else {
            out.writeByte((byte)-1);
            out.writeLong(doubleBits);
        }
    }

    static void writeTLong(DataOutput out, long l) throws IOException {
        int header;
        if (l % 1000L != 0L) {
            header = 0;
        } else if (l % 86400000L == 0L) {
            header = 192;
            l /= 86400000L;
        } else if (l % 3600000L == 0L) {
            header = 128;
            l /= 3600000L;
        } else {
            header = 64;
            l /= 1000L;
        }
        long zigZagL = BitUtil.zigZagEncode(l);
        header = (int)((long)header | zigZagL & 0x1FL);
        long upperBits = zigZagL >>> 5;
        if (upperBits != 0L) {
            header |= 0x20;
        }
        out.writeByte((byte)header);
        if (upperBits != 0L) {
            out.writeVLong(upperBits);
        }
    }

    @Override
    public void finish(FieldInfos fis, int numDocs) throws IOException {
        if (this.numBufferedDocs > 0) {
            ++this.numDirtyChunks;
            long expectedChunkDocs = Math.min((long)this.maxDocsPerChunk, (long)((double)this.chunkSize / (double)this.bufferedDocs.size() * (double)this.numBufferedDocs));
            this.numDirtyDocs += expectedChunkDocs - (long)this.numBufferedDocs;
            this.flush();
        } else assert (this.bufferedDocs.size() == 0L);
        if (this.docBase != numDocs) {
            throw new RuntimeException("Wrote " + this.docBase + " docs, finish called with numDocs=" + numDocs);
        }
        this.indexWriter.finish(numDocs, this.fieldsStream.getFilePointer(), this.metaStream);
        this.metaStream.writeVLong(this.numDirtyChunks);
        this.metaStream.writeVLong(this.numDirtyDocs);
        CodecUtil.writeFooter(this.metaStream);
        CodecUtil.writeFooter(this.fieldsStream);
        assert (this.bufferedDocs.size() == 0L);
    }

    @Override
    public int merge(MergeState mergeState) throws IOException {
        int docCount = 0;
        int numReaders = mergeState.maxDocs.length;
        MatchingReaders matching = new MatchingReaders(mergeState);
        if (mergeState.needsIndexSort) {
            CompressingStoredFieldsMergeSub sub;
            ArrayList<CompressingStoredFieldsMergeSub> subs = new ArrayList<CompressingStoredFieldsMergeSub>();
            for (int i = 0; i < mergeState.storedFieldsReaders.length; ++i) {
                if (!matching.matchingReaders[i] || !(mergeState.storedFieldsReaders[i] instanceof CompressingStoredFieldsReader)) {
                    return super.merge(mergeState);
                }
                CompressingStoredFieldsReader storedFieldsReader = (CompressingStoredFieldsReader)mergeState.storedFieldsReaders[i];
                storedFieldsReader.checkIntegrity();
                subs.add(new CompressingStoredFieldsMergeSub(storedFieldsReader, mergeState.docMaps[i], mergeState.maxDocs[i]));
            }
            DocIDMerger docIDMerger = DocIDMerger.of(subs, true);
            while ((sub = (CompressingStoredFieldsMergeSub)docIDMerger.next()) != null) {
                assert (sub.mappedDocID == docCount);
                CompressingStoredFieldsReader.SerializedDocument doc = sub.reader.document(sub.docID);
                this.startDocument();
                this.bufferedDocs.copyBytes(doc.in, doc.length);
                this.numStoredFieldsInDoc = doc.numStoredFields;
                this.finishDocument();
                ++docCount;
            }
            this.finish(mergeState.mergeFieldInfos, docCount);
            return docCount;
        }
        for (int readerIndex = 0; readerIndex < numReaders; ++readerIndex) {
            StoredFieldsReader fieldsReader;
            StoredFieldsWriter.MergeVisitor visitor = new StoredFieldsWriter.MergeVisitor(mergeState, readerIndex);
            CompressingStoredFieldsReader matchingFieldsReader = null;
            if (matching.matchingReaders[readerIndex] && (fieldsReader = mergeState.storedFieldsReaders[readerIndex]) != null && fieldsReader instanceof CompressingStoredFieldsReader) {
                matchingFieldsReader = (CompressingStoredFieldsReader)fieldsReader;
            }
            int maxDoc = mergeState.maxDocs[readerIndex];
            Bits liveDocs = mergeState.liveDocs[readerIndex];
            if (matchingFieldsReader == null || matchingFieldsReader.getVersion() != 3 || !BULK_MERGE_ENABLED) {
                StoredFieldsReader storedFieldsReader = mergeState.storedFieldsReaders[readerIndex];
                if (storedFieldsReader != null) {
                    storedFieldsReader.checkIntegrity();
                }
                for (int docID = 0; docID < maxDoc; ++docID) {
                    if (liveDocs != null && !liveDocs.get(docID)) continue;
                    this.startDocument();
                    storedFieldsReader.visitDocument(docID, visitor);
                    this.finishDocument();
                    ++docCount;
                }
                continue;
            }
            if (matchingFieldsReader.getCompressionMode() == this.compressionMode && matchingFieldsReader.getChunkSize() == this.chunkSize && matchingFieldsReader.getPackedIntsVersion() == 2 && liveDocs == null && !this.tooDirty(matchingFieldsReader)) {
                assert (matchingFieldsReader.getVersion() == 3);
                matchingFieldsReader.checkIntegrity();
                if (this.numBufferedDocs > 0) {
                    this.flush();
                    ++this.numDirtyChunks;
                }
                IndexInput rawDocs = matchingFieldsReader.getFieldsStream();
                FieldsIndex index = matchingFieldsReader.getIndexReader();
                rawDocs.seek(index.getStartPointer(0));
                int docID = 0;
                while (docID < maxDoc) {
                    int base = rawDocs.readVInt();
                    if (base != docID) {
                        throw new CorruptIndexException("invalid state: base=" + base + ", docID=" + docID, rawDocs);
                    }
                    int code = rawDocs.readVInt();
                    int bufferedDocs = code >>> 1;
                    this.indexWriter.writeIndex(bufferedDocs, this.fieldsStream.getFilePointer());
                    this.fieldsStream.writeVInt(this.docBase);
                    this.fieldsStream.writeVInt(code);
                    this.docBase += bufferedDocs;
                    docCount += bufferedDocs;
                    if ((docID += bufferedDocs) > maxDoc) {
                        throw new CorruptIndexException("invalid state: base=" + base + ", count=" + bufferedDocs + ", maxDoc=" + maxDoc, rawDocs);
                    }
                    long end = docID == maxDoc ? matchingFieldsReader.getMaxPointer() : index.getStartPointer(docID);
                    this.fieldsStream.copyBytes(rawDocs, end - rawDocs.getFilePointer());
                }
                if (rawDocs.getFilePointer() != matchingFieldsReader.getMaxPointer()) {
                    throw new CorruptIndexException("invalid state: pos=" + rawDocs.getFilePointer() + ", max=" + matchingFieldsReader.getMaxPointer(), rawDocs);
                }
                this.numDirtyChunks += matchingFieldsReader.getNumDirtyChunks();
                this.numDirtyDocs += matchingFieldsReader.getNumDirtyDocs();
                continue;
            }
            assert (matchingFieldsReader.getVersion() == 3);
            matchingFieldsReader.checkIntegrity();
            for (int docID = 0; docID < maxDoc; ++docID) {
                if (liveDocs != null && !liveDocs.get(docID)) continue;
                CompressingStoredFieldsReader.SerializedDocument doc = matchingFieldsReader.document(docID);
                this.startDocument();
                this.bufferedDocs.copyBytes(doc.in, doc.length);
                this.numStoredFieldsInDoc = doc.numStoredFields;
                this.finishDocument();
                ++docCount;
            }
        }
        this.finish(mergeState.mergeFieldInfos, docCount);
        return docCount;
    }

    boolean tooDirty(CompressingStoredFieldsReader candidate) {
        return candidate.getNumDirtyChunks() > 1024L || candidate.getNumDirtyDocs() * 100L > (long)candidate.getNumDocs();
    }

    @Override
    public long ramBytesUsed() {
        return this.bufferedDocs.ramBytesUsed() + (long)(this.numStoredFields.length * 4) + (long)(this.endOffsets.length * 4);
    }

    static {
        boolean v = true;
        try {
            v = Boolean.parseBoolean(System.getProperty(BULK_MERGE_ENABLED_SYSPROP, "true"));
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        BULK_MERGE_ENABLED = v;
    }

    private static class CompressingStoredFieldsMergeSub
    extends DocIDMerger.Sub {
        private final CompressingStoredFieldsReader reader;
        private final int maxDoc;
        int docID = -1;

        CompressingStoredFieldsMergeSub(CompressingStoredFieldsReader reader, MergeState.DocMap docMap, int maxDoc) {
            super(docMap);
            this.maxDoc = maxDoc;
            this.reader = reader;
        }

        @Override
        public int nextDoc() {
            ++this.docID;
            if (this.docID == this.maxDoc) {
                return Integer.MAX_VALUE;
            }
            return this.docID;
        }
    }
}

