/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.util.Iterator;
import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.util.PropertiesUtil;

public final class Strings {
    public static final String EMPTY = "";
    public static final String LINE_SEPARATOR = PropertiesUtil.getProperties().getStringProperty("line.separator", "\n");

    public static String dquote(String str2) {
        return '\"' + str2 + '\"';
    }

    public static boolean isBlank(String s) {
        if (s == null || s.isEmpty()) {
            return true;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return !Strings.isBlank(s);
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !Strings.isEmpty(cs);
    }

    public static String join(Iterable<?> iterable, char separator) {
        if (iterable == null) {
            return null;
        }
        return Strings.join(iterable.iterator(), separator);
    }

    public static String join(Iterator<?> iterator, char separator) {
        if (iterator == null) {
            return null;
        }
        if (!iterator.hasNext()) {
            return EMPTY;
        }
        Object first = iterator.next();
        if (!iterator.hasNext()) {
            return Objects.toString(first, EMPTY);
        }
        StringBuilder buf = new StringBuilder(256);
        if (first != null) {
            buf.append(first);
        }
        while (iterator.hasNext()) {
            buf.append(separator);
            Object obj = iterator.next();
            if (obj == null) continue;
            buf.append(obj);
        }
        return buf.toString();
    }

    public static String left(String str2, int len) {
        if (str2 == null) {
            return null;
        }
        if (len < 0) {
            return EMPTY;
        }
        if (str2.length() <= len) {
            return str2;
        }
        return str2.substring(0, len);
    }

    public static String quote(String str2) {
        return '\'' + str2 + '\'';
    }

    public static String trimToNull(String str2) {
        String ts = str2 == null ? null : str2.trim();
        return Strings.isEmpty(ts) ? null : ts;
    }

    private Strings() {
    }

    public static String toRootUpperCase(String str2) {
        return str2.toUpperCase(Locale.ROOT);
    }

    public static String repeat(String str2, int count) {
        Objects.requireNonNull(str2, "str");
        if (count < 0) {
            throw new IllegalArgumentException("count");
        }
        StringBuilder sb = new StringBuilder(str2.length() * count);
        for (int index = 0; index < count; ++index) {
            sb.append(str2);
        }
        return sb.toString();
    }
}

