/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.bulkloader2;

import java.util.Iterator;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.tdb.base.block.BlockMgr;
import org.apache.jena.tdb.base.block.BlockMgrFactory;
import org.apache.jena.tdb.base.file.FileSet;
import org.apache.jena.tdb.base.file.Location;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.index.RangeIndex;
import org.apache.jena.tdb.index.SetupIndex;
import org.apache.jena.tdb.index.bplustree.BPlusTree;
import org.apache.jena.tdb.index.bplustree.BPlusTreeParams;
import org.apache.jena.tdb.index.bplustree.BPlusTreeRewriter;

public class ProcRewriteIndex {
    public static void exec(Location srcLoc, Location dstLoc, String indexName) {
        int dftValueLength;
        int dftKeyLength;
        FileSet destination = new FileSet(dstLoc, indexName);
        int readCacheSize = 0;
        int writeCacheSize = -1;
        if (indexName.length() == 3) {
            dftKeyLength = 24;
            dftValueLength = 0;
        } else if (indexName.length() == 4) {
            dftKeyLength = 32;
            dftValueLength = 0;
        } else {
            FmtLog.error(ProcRewriteIndex.class, "Can't determine record size for %s\n", indexName);
            return;
        }
        RecordFactory recordFactory = null;
        BPlusTreeParams bptParams = null;
        int blockSize = 8192;
        RangeIndex rangeIndex = SetupIndex.makeRangeIndex(srcLoc, indexName, blockSize, dftKeyLength, dftValueLength, readCacheSize, writeCacheSize);
        BPlusTree bpt = (BPlusTree)rangeIndex;
        bptParams = bpt.getParams();
        recordFactory = bpt.getRecordFactory();
        int blockSizeNodes = blockSize;
        int blockSizeRecords = blockSize;
        BlockMgr blkMgrNodes = BlockMgrFactory.create(destination, "idn", blockSizeNodes, readCacheSize, writeCacheSize);
        BlockMgr blkMgrRecords = BlockMgrFactory.create(destination, "dat", blockSizeRecords, readCacheSize, writeCacheSize);
        Iterator<Record> iterator = bpt.iterator();
        BPlusTree bpt2 = BPlusTreeRewriter.packIntoBPlusTree(iterator, bptParams, recordFactory, blkMgrNodes, blkMgrRecords);
        if (bpt2 == null) {
            return;
        }
        bpt2.close();
    }
}

