/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.IteratorWrapper;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.sparql.engine.iterator.Abortable;

public class IterAbortable<T>
extends IteratorWrapper<T>
implements Abortable {
    volatile boolean abortFlag = false;

    public IterAbortable(Iterator<T> iterator) {
        super(iterator);
    }

    @Override
    public void abort() {
        this.abortFlag = true;
    }

    @Override
    public boolean hasNext() {
        if (this.abortFlag) {
            throw new QueryCancelledException();
        }
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        if (this.abortFlag) {
            throw new QueryCancelledException();
        }
        return (T)this.iterator.next();
    }
}

