/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHACL;

public class NodeKindConstraint
extends ConstraintTerm {
    private final Node kind;
    private final boolean canBeIRI;
    private final boolean canBeBlankNode;
    private final boolean canBeLiteral;

    public NodeKindConstraint(Node kind) {
        Objects.requireNonNull(kind);
        if (!kind.isURI()) {
            throw new IllegalArgumentException("NodeKindConstraint; not an IRI for the kind kind");
        }
        this.kind = kind;
        this.canBeIRI = kind.equals(SHACL.IRI) || kind.equals(SHACL.BlankNodeOrIRI) || kind.equals(SHACL.IRIOrLiteral);
        this.canBeBlankNode = kind.equals(SHACL.BlankNode) || kind.equals(SHACL.BlankNodeOrIRI) || kind.equals(SHACL.BlankNodeOrLiteral);
        boolean bl = this.canBeLiteral = kind.equals(SHACL.Literal) || kind.equals(SHACL.BlankNodeOrLiteral) || kind.equals(SHACL.IRIOrLiteral);
        if (!(this.canBeIRI || this.canBeBlankNode || this.canBeLiteral)) {
            throw new IllegalArgumentException("NodeKind[" + kind.getLocalName() + "] : not one of sh:BlankNode, sh:IRI, sh:Literal sh:BlankNodeOrIRI, sh:BlankNodeOrLiteral and sh:IRIOrLiteral");
        }
    }

    public Node getKind() {
        return this.kind;
    }

    public boolean isCanBeIRI() {
        return this.canBeIRI;
    }

    public boolean isCanBeBlankNode() {
        return this.canBeBlankNode;
    }

    public boolean isCanBeLiteral() {
        return this.canBeLiteral;
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        String s = this.getKind().getLocalName();
        out.print(s);
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Node n) {
        if (this.canBeIRI && n.isURI()) {
            return null;
        }
        if (this.canBeBlankNode && n.isBlank()) {
            return null;
        }
        if (this.canBeLiteral && n.isLiteral()) {
            return null;
        }
        String msg = this.toString() + " : Expected " + this.kind.getLocalName() + " for " + ShLib.displayStr(n);
        return new ReportItem(msg, n);
    }

    @Override
    public Node getComponent() {
        return SHACL.NodeKindConstraintComponent;
    }

    @Override
    public void print(IndentedWriter out, NodeFormatter nodeFmt) {
        out.print(this.toString());
    }

    public String toString() {
        return "NodeKind[" + this.kind.getLocalName() + "]";
    }

    public int hashCode() {
        return Objects.hash(this.canBeBlankNode, this.canBeIRI, this.canBeLiteral, this.kind);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeKindConstraint)) {
            return false;
        }
        NodeKindConstraint other = (NodeKindConstraint)obj;
        return this.canBeBlankNode == other.canBeBlankNode && this.canBeIRI == other.canBeIRI && this.canBeLiteral == other.canBeLiteral && Objects.equals(this.kind, other.kind);
    }
}

