/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.jena.atlas.lib.CollectionUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.other.G;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.engine.Target;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.sys.C;
import org.apache.jena.shacl.vocabulary.SHACL;

public class TargetOps {
    public static String strTargets(Collection<Target> targets, NodeFormatter nodeFmt) {
        if (targets.size() == 1) {
            return TargetOps.strTarget(CollectionUtils.oneElt(targets), nodeFmt);
        }
        StringJoiner sj = new StringJoiner(", ", "(", ")");
        targets.forEach(t -> sj.add(TargetOps.strTarget(t, nodeFmt)));
        return sj.toString();
    }

    public static String strTarget(Target target, NodeFormatter nodeFmt) {
        if (nodeFmt == null) {
            nodeFmt = ShLib.nodeFmtAbbrev;
        }
        switch (target.getTargetType()) {
            case implicitClass: {
                return "T/Impl [" + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
            case targetClass: {
                return "T/Class [?x rdf:type " + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
            case targetNode: {
                return "T/Node [?x = " + ShLib.displayStr(target.getObject(), nodeFmt) + "]";
            }
            case targetObjectsOf: {
                return "T/Obj [_ " + ShLib.displayStr(target.getObject(), nodeFmt) + " ?x]";
            }
            case targetSubjectsOf: {
                return "T/Subj [?x " + ShLib.displayStr(target.getObject(), nodeFmt) + " _]";
            }
        }
        return "** Unknown **";
    }

    public static Set<Node> shapesTargetClass(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetClass, null).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> shapesTargetNode(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetNode, Node.ANY).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> shapesTargetObjectsOf(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetObjectsOf, Node.ANY).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> shapesTargetSubjectsOf(Graph shapesGraph) {
        return shapesGraph.find(Node.ANY, SHACL.targetSubjectsOf, Node.ANY).mapWith(Triple::getSubject).toSet();
    }

    public static Set<Node> implicitClassTargets(Graph shapesGraph) {
        Set<Node> allClasses = G.allNodesOfTypeRDFS(shapesGraph, C.rdfsClass);
        if (allClasses.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Node> nodeShapes = G.allNodesOfTypeRDFS(shapesGraph, SHACL.NodeShape);
        Set<Node> propertyShapes = G.allNodesOfTypeRDFS(shapesGraph, SHACL.PropertyShape);
        nodeShapes.retainAll(allClasses);
        propertyShapes.retainAll(allClasses);
        HashSet<Node> acc = new HashSet<Node>();
        acc.addAll(nodeShapes);
        acc.addAll(propertyShapes);
        return acc;
    }
}

