/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import org.apache.jena.atlas.io.AWriter;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.CharSpace;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.riot.out.NodeFormatterNT;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.Quad;

public class WriterStreamRDFPlain
implements StreamRDF {
    protected final AWriter out;
    protected final NodeFormatter nodeFmt;

    public WriterStreamRDFPlain(AWriter w) {
        this(w, CharSpace.UTF8);
    }

    public WriterStreamRDFPlain(AWriter w, CharSpace charSpace) {
        this.out = w;
        this.nodeFmt = new NodeFormatterNT(charSpace);
    }

    @Override
    public void start() {
    }

    @Override
    public void finish() {
        IO.flush(this.out);
    }

    @Override
    public void triple(Triple triple) {
        Node s = triple.getSubject();
        Node p = triple.getPredicate();
        Node o = triple.getObject();
        this.format(s);
        this.out.print(" ");
        this.format(p);
        this.out.print(" ");
        this.format(o);
        this.out.print(" .\n");
    }

    @Override
    public void quad(Quad quad) {
        Node s = quad.getSubject();
        Node p = quad.getPredicate();
        Node o = quad.getObject();
        Node g = quad.getGraph();
        this.format(s);
        this.out.print(" ");
        this.format(p);
        this.out.print(" ");
        this.format(o);
        if (WriterStreamRDFPlain.outputGraphSlot(g)) {
            this.out.print(" ");
            this.format(g);
        }
        this.out.print(" .\n");
    }

    private void format(Node n) {
        this.nodeFmt.format(this.out, n);
    }

    @Override
    public void base(String base) {
    }

    @Override
    public void prefix(String prefix, String iri2) {
    }

    private static boolean outputGraphSlot(Node g) {
        return g != null && g != Quad.tripleInQuad && !Quad.isDefaultGraph(g);
    }
}

