/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.system;

import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;
import org.apache.jena.riot.system.Prefixes;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.SplitIRI;

public final class PrefixMapAdapter
extends PrefixMapBase
implements PrefixMap {
    private final PrefixMapping prefixMapping;

    public PrefixMapAdapter(PrefixMapping prefixMapping) {
        this.prefixMapping = prefixMapping;
    }

    public PrefixMapping getPrefixMapping() {
        return this.prefixMapping;
    }

    @Override
    public String get(String prefix) {
        return this.prefixMapping.getNsPrefixURI(prefix);
    }

    @Override
    public Map<String, String> getMappingCopy() {
        return this.prefixMapping.getNsPrefixMap();
    }

    @Override
    public Map<String, String> getMapping() {
        return this.prefixMapping.getNsPrefixMap();
    }

    @Override
    public void add(String prefix, String iriString) {
        this.prefixMapping.setNsPrefix(prefix, iriString);
    }

    @Override
    public void delete(String prefix) {
        this.prefixMapping.removeNsPrefix(prefix);
    }

    @Override
    public void clear() {
        this.prefixMapping.clearNsPrefixMap();
    }

    @Override
    public boolean containsPrefix(String prefix) {
        return this.prefixMapping.getNsPrefixURI(prefix) != null;
    }

    @Override
    public String abbreviate(String uriStr) {
        return this.prefixMapping.qnameFor(uriStr);
    }

    @Override
    public Pair<String, String> abbrev(String uriStr) {
        int split = SplitIRI.splitXML(uriStr);
        if (split == uriStr.length()) {
            return null;
        }
        String ns = uriStr.substring(0, split);
        String local = uriStr.substring(split);
        return Pair.create(ns, local);
    }

    @Override
    public String expand(String prefix, String localName) {
        String prefixUri = this.prefixMapping.getNsPrefixURI(prefix);
        if (prefixUri == null) {
            return null;
        }
        return prefixUri + localName;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public int size() {
        return this.prefixMapping.numPrefixes();
    }

    @Override
    public String toString() {
        return Prefixes.toString(this);
    }
}

