/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.irix;

import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.irix.IRIException;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.IRIProviderJenaIRI;
import org.apache.jena.irix.IRIs;
import org.apache.jena.irix.IRIx;

public class SystemIRIx {
    private static IRIProvider providerJenaIRI;
    private static IRIProvider provider;
    private static final IRIx cwdURI;
    private static IRIx systemBase;
    private static String fallbackBaseURI;

    public static void init() {
    }

    public static void setProvider(IRIProvider aProvider) {
        provider = aProvider;
        IRIx iri2 = SystemIRIx.setupBase(systemBase.str());
        SystemIRIx.setSystemBase(iri2);
    }

    public static IRIProvider getProvider() {
        return provider;
    }

    public static void strictMode(String scheme, boolean runStrict) {
        SystemIRIx.getProvider().strictMode(scheme, runStrict);
    }

    public static boolean isStrictMode(String scheme) {
        return SystemIRIx.getProvider().isStrictMode(scheme);
    }

    static IRIx getSystemBase() {
        return systemBase;
    }

    private static IRIx establishBaseURI() {
        try {
            Object baseStr = IRILib.filenameToIRI("./");
            if (!((String)baseStr).endsWith("/")) {
                baseStr = (String)baseStr + "/";
            }
            return SystemIRIx.setupBase((String)baseStr);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            return IRIx.create(fallbackBaseURI);
        }
    }

    private static IRIx setupBase(String baseStr) {
        if (baseStr == null) {
            return IRIx.create(fallbackBaseURI);
        }
        try {
            IRIx base;
            if (!((String)baseStr).endsWith("/")) {
                baseStr = (String)baseStr + "/";
            }
            if (!(base = IRIx.create((String)baseStr)).isReference()) {
                Log.error(IRIs.class, "System base URI is not a reference URI: must have scheme, host and path");
            }
            return base;
        }
        catch (IRIException ex) {
            Log.error(IRIs.class, "Failed to create IRI from '" + (String)baseStr + "'", ex);
            return IRIx.create(fallbackBaseURI);
        }
    }

    private static void setSystemBase(IRIx iri2) {
        systemBase = iri2;
    }

    static {
        provider = providerJenaIRI = new IRIProviderJenaIRI();
        provider.strictMode("urn", false);
        provider.strictMode("http", false);
        provider.strictMode("file", false);
        systemBase = cwdURI = SystemIRIx.establishBaseURI();
        fallbackBaseURI = "urn:jena:base";
    }
}

