/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.webapp;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.webapp.FusekiEnv;
import org.apache.jena.fuseki.webapp.FusekiWebapp;
import org.apache.jena.irix.IRIs;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.io.ResourceUtils;
import org.apache.shiro.web.env.EnvironmentLoader;
import org.apache.shiro.web.env.ResourceBasedWebEnvironment;
import org.apache.shiro.web.env.WebEnvironment;

public class ShiroEnvironmentLoader
extends EnvironmentLoader
implements ServletContextListener {
    private ServletContext servletContext;
    private static final String FILE = "file";

    @Override
    public void contextInitialized(ServletContextEvent sce) {
        FusekiWebapp.formatBaseArea();
        this.servletContext = sce.getServletContext();
        try {
            this.initEnvironment(this.servletContext);
        }
        catch (ConfigurationException ex) {
            Fuseki.configLog.error("Shiro initialization failed: " + ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void contextDestroyed(ServletContextEvent sce) {
        this.destroyEnvironment(sce.getServletContext());
    }

    @Override
    protected void customizeEnvironment(WebEnvironment environment) {
        if (environment instanceof ResourceBasedWebEnvironment) {
            ResourceBasedWebEnvironment env = (ResourceBasedWebEnvironment)environment;
            String[] locations = env.getConfigLocations();
            String loc = ShiroEnvironmentLoader.huntForShiroIni(locations);
            Fuseki.configLog.info("Shiro file: " + loc);
            if (loc != null) {
                locations = new String[]{loc};
            }
            env.setConfigLocations(locations);
        }
    }

    private static String huntForShiroIni(String[] locations) {
        FusekiEnv.setEnvironment();
        Fuseki.init();
        for (String loc : locations) {
            String string;
            block12: {
                Path p;
                String scheme = IRIs.scheme(loc);
                if (scheme != null) {
                    if (scheme.equalsIgnoreCase(FILE) && !(p = Paths.get(loc.substring(FILE.length() + 1), new String[0])).toFile().exists()) continue;
                    return loc;
                }
                p = Paths.get(loc, new String[0]);
                String fn = ShiroEnvironmentLoader.resolve(FusekiEnv.FUSEKI_BASE, p);
                if (fn != null) {
                    return "file://" + fn;
                }
                fn = ShiroEnvironmentLoader.resolve(FusekiEnv.FUSEKI_HOME, p);
                if (fn != null) {
                    return "file://" + fn;
                }
                InputStream is = ResourceUtils.getInputStreamForPath(loc);
                try {
                    boolean exists = is != null;
                    string = loc;
                    if (is == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                is.close();
            }
            return string;
        }
        return null;
    }

    private static String resolve(Path dir, Path file) {
        Path p = dir.resolve(file);
        if (p.toFile().exists()) {
            return p.normalize().toString();
        }
        return null;
    }
}

