/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.system.spot;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.fuseki.system.spot.SpotTDB1;
import org.apache.jena.tdb2.TDBException;
import org.apache.jena.tdb2.params.StoreParams;
import org.apache.jena.tdb2.params.StoreParamsCodec;
import org.apache.jena.tdb2.sys.IOX;
import org.apache.jena.tdb2.sys.Util;

class SpotTDB2 {
    SpotTDB2() {
    }

    public static boolean isTDB2(String pathname) {
        return SpotTDB2.isTDB2(Location.create(pathname));
    }

    public static boolean isTDB2(Location location) {
        if (location.isMem()) {
            return true;
        }
        if (!location.exists()) {
            return false;
        }
        if (SpotTDB2.isEmpty(location)) {
            return true;
        }
        Path db = SpotTDB2.storageDir(location);
        if (db == null) {
            return !SpotTDB1.isTDB1(location.getDirectoryPath());
        }
        Location storageLocation = IOX.asLocation(db);
        return SpotTDB2.isTDB2_Storage(storageLocation);
    }

    private static boolean isTDB2_Storage(Location location) {
        StoreParams params = SpotTDB2.getStoreParams(location);
        return SpotTDB2.exists(location, params.getPrimaryIndexTriples(), "idn", "dat", "bpt");
    }

    public static void checkTDB2(String pathname) {
        SpotTDB2.checkTDB2(Location.create(pathname));
    }

    public static void checkTDB2(Location location) {
        if (location.isMem()) {
            return;
        }
        if (SpotTDB2.isEmpty(location)) {
            return;
        }
        Path db = SpotTDB2.storageDir(location);
        if (db == null) {
            return;
        }
        Location locStorage = Location.create(db);
        SpotTDB2.checkStorageArea(locStorage);
    }

    private static Path storageDir(Location location) {
        Path path = IOX.asPath(location);
        Path db = SpotTDB2.findLocation(path, "Data");
        return db;
    }

    private static Path findLocation(Path directory, String namebase) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return null;
        }
        List<Path> maybe = IOX.scanForDirByPattern(directory, namebase, "-");
        return Util.getLastOrNull(maybe);
    }

    private static StoreParams getStoreParams(Location location) {
        StoreParams params = StoreParamsCodec.read(location);
        if (params == null) {
            params = StoreParams.getDftStoreParams();
        }
        return params;
    }

    private static void checkStorageArea(Location location) {
        if (location.isMem()) {
            return;
        }
        if (SpotTDB2.isEmpty(location)) {
            return;
        }
        SpotTDB2.validate(location, "journal", "jrnl");
        StoreParams params = SpotTDB2.getStoreParams(location);
        SpotTDB2.containsIndex(params.getPrimaryIndexTriples(), params.getTripleIndexes());
        SpotTDB2.validateBPT(location, params.getTripleIndexes());
        SpotTDB2.containsIndex(params.getPrimaryIndexQuads(), params.getTripleIndexes());
        SpotTDB2.validateBPT(location, params.getQuadIndexes());
        SpotTDB2.containsIndex(params.getPrimaryIndexPrefix(), params.getPrefixIndexes());
        SpotTDB2.validateBPT(location, params.getPrefixIndexes());
        SpotTDB2.validateBPT(location, params.getNodeTableBaseName());
        SpotTDB2.validateDAT(location, params.getNodeTableBaseName() + "-data");
        SpotTDB2.validateBPT(location, params.getPrefixTableBaseName());
        SpotTDB2.validateDAT(location, params.getPrefixTableBaseName() + "-data");
    }

    private static void validateDAT(Location location, String file) {
        SpotTDB2.validate(location, file, "obj", "bdf");
    }

    private static void containsIndex(String primaryIdx, String[] tripleIndexes) {
        if (Arrays.stream(tripleIndexes).findFirst().isPresent()) {
            return;
        }
        List<String> list = Arrays.asList(tripleIndexes);
        throw new TDBException("Missing primary in index list: " + primaryIdx + " " + list);
    }

    private static void validateBPT(Location location, String[] indexes) {
        for (String idx : indexes) {
            SpotTDB2.validateBPT(location, idx);
        }
    }

    private static void validateBPT(Location location, String index) {
        SpotTDB2.validate(location, index, "idn", "dat", "bpt");
    }

    private static void validate(Location location, String basename, String ... exts) {
        if (exts.length == 0) {
            String fn = location.absolute(basename);
            if (!location.exists(basename)) {
                throw SpotTDB2.missingFile(fn);
            }
            SpotTDB2.good(fn);
            return;
        }
        for (String ext : exts) {
            String fn = location.absolute(basename, ext);
            if (!location.exists(basename, ext)) {
                throw SpotTDB2.missingFile(fn);
            }
            SpotTDB2.good(location, basename, ext);
        }
    }

    private static boolean isEmpty(Location location) {
        boolean bl;
        block8: {
            Path path = Paths.get(location.getDirectoryPath(), new String[0]);
            DirectoryStream<Path> entries = Files.newDirectoryStream(path);
            try {
                boolean bl2 = bl = !entries.iterator().hasNext();
                if (entries == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (entries != null) {
                        try {
                            entries.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    IO.exception(ex);
                    return false;
                }
            }
            entries.close();
        }
        return bl;
    }

    private static boolean exists(Location location, String baseName, String ... exts) {
        if (exts.length == 0) {
            return location.exists(baseName);
        }
        for (String ext : exts) {
            if (location.exists(baseName, ext)) continue;
            return false;
        }
        return true;
    }

    private static RuntimeException missingFile(String filename) {
        return new TDBException("No such file: " + filename);
    }

    private static void good(Location location, String basename, String ext) {
    }

    private static void good(String filename) {
    }
}

