/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.FusekiException;
import org.apache.jena.fuseki.server.DataAccessPoint;
import org.apache.jena.fuseki.server.DataAccessPointRegistry;
import org.apache.jena.fuseki.server.DataService;
import org.apache.jena.fuseki.server.Endpoint;
import org.apache.jena.fuseki.server.OperationRegistry;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpServletResponseTracker;
import org.apache.jena.fuseki.system.ActionCategory;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalLock;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;

public class HttpAction {
    public final long id;
    public final boolean verbose;
    public final ActionCategory category;
    public final Logger log;
    public Endpoint endpoint = null;
    private Transactional transactional = null;
    private boolean isTransactional = false;
    private DatasetGraph activeDSG = null;
    private DataAccessPoint dataAccessPoint = null;
    private DataService dataService = null;
    private String datasetName = null;
    private DatasetGraph dsg = null;
    private Context context = null;
    private boolean startTimeIsSet = false;
    private boolean finishTimeIsSet = false;
    private long startTime = -2L;
    private long finishTime = -2L;
    public int statusCode = -1;
    public String message = null;
    public int responseContentLength = -1;
    public String responseContentType = null;
    public Map<String, String> headers = new HashMap<String, String>();
    public HttpServletRequest request;
    public HttpServletResponseTracker response;
    private final String actionURI;
    private final String contextPath;
    private final OperationRegistry serviceDispatchRegistry;
    private final DataAccessPointRegistry dataAccessPointRegistry;

    public HttpAction(long id, Logger log2, ActionCategory category, HttpServletRequest request, HttpServletResponse response) {
        this.id = id;
        this.verbose = Fuseki.getVerbose(request.getServletContext());
        this.log = log2;
        this.category = category;
        this.request = request;
        this.response = new HttpServletResponseTracker(this, response);
        this.contextPath = request.getServletContext().getContextPath();
        this.actionURI = ActionLib.actionURI(request);
        this.serviceDispatchRegistry = OperationRegistry.get(request.getServletContext());
        this.dataAccessPointRegistry = DataAccessPointRegistry.get(request.getServletContext());
    }

    public void setRequest(DataAccessPoint dataAccessPoint, DataService dService) {
        if (this.dataAccessPoint != null) {
            throw new FusekiException("Redefinition of DataAccessPoint in the request action");
        }
        this.dataAccessPoint = dataAccessPoint;
        if (dataAccessPoint != null) {
            this.datasetName = dataAccessPoint.getName();
        }
        if (this.dataService != null) {
            throw new FusekiException("Redefinition of DatasetRef in the request action");
        }
        if (dService == null || dService.getDataset() == null) {
            throw new FusekiException("Null DataService in the request action");
        }
        this.dataService = dService;
        this.setDataset(dService.getDataset());
    }

    private void setDataset(DatasetGraph dsg) {
        this.dsg = dsg;
        this.context = Context.mergeCopy(Fuseki.getContext(), dsg.getContext());
        if (dsg == null) {
            return;
        }
        this.setTransactionalPolicy(dsg);
    }

    private void setTransactionalPolicy(DatasetGraph dsg) {
        if (dsg.supportsTransactionAbort()) {
            this.transactional = dsg;
            this.isTransactional = true;
        } else if (dsg.supportsTransactions()) {
            this.transactional = dsg;
            this.isTransactional = false;
        } else {
            this.transactional = TransactionalLock.createMutex();
            this.isTransactional = false;
        }
    }

    public DatasetGraph getDataset() {
        return this.dsg;
    }

    public Context getContext() {
        return this.context;
    }

    public String getUser() {
        if (this.request == null) {
            return null;
        }
        return this.request.getRemoteUser();
    }

    public Transactional getTransactional() {
        return this.transactional;
    }

    public String getActionURI() {
        return this.actionURI;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public OperationRegistry getOperationRegistry() {
        return this.serviceDispatchRegistry;
    }

    public DataAccessPointRegistry getDataAccessPointRegistry() {
        return this.dataAccessPointRegistry;
    }

    public void setEndpoint(Endpoint endpoint) {
        if (endpoint != null) {
            this.context = Context.mergeCopy(this.getContext(), endpoint.getContext());
        }
        this.endpoint = endpoint;
    }

    public Endpoint getEndpoint() {
        return this.endpoint;
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public void begin(TxnType txnType) {
        if (this.transactional != null) {
            this.transactional.begin(txnType);
        }
        this.activeDSG = this.dsg;
        if (this.dataService != null) {
            this.dataService.startTxn(txnType);
        }
    }

    public void begin() {
        this.begin(TxnType.READ_PROMOTE);
    }

    public void beginWrite() {
        this.begin(TxnType.WRITE);
    }

    public void beginRead() {
        this.begin(TxnType.READ);
    }

    public void endRead() {
        if (this.dataService != null) {
            this.dataService.finishTxn();
        }
        if (this.transactional != null) {
            try {
                this.transactional.commit();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                this.transactional.end();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.activeDSG = null;
    }

    public void end() {
        this.dataService.finishTxn();
        if (this.transactional.isInTransaction()) {
            Log.warn(this, "Transaction still active - no commit or abort seen (forced abort)");
            try {
                this.transactional.abort();
            }
            catch (RuntimeException ex) {
                Log.warn(this, "Exception in forced abort (trying to continue)", ex);
            }
        }
        if (this.transactional.isInTransaction()) {
            try {
                this.transactional.end();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.activeDSG = null;
    }

    public void commit() {
        this.dataService.finishTxn();
        this.transactional.commit();
        this.end();
    }

    public void abortSilent() {
        try {
            this.transactional.abort();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.end();
            }
            catch (Exception exception) {}
        }
    }

    public void abort() {
        try {
            this.transactional.abort();
        }
        catch (Exception ex) {
            Log.warn(this, "Exception during abort (operation attempts to continue): " + ex.getMessage());
        }
        this.end();
    }

    public final void startRequest() {
        if (this.dataAccessPoint != null) {
            this.dataAccessPoint.startRequest(this);
        }
    }

    public final void finishRequest() {
        if (this.dataAccessPoint != null) {
            this.dataAccessPoint.finishRequest(this);
        }
    }

    public final DatasetGraph getActiveDSG() {
        return this.activeDSG;
    }

    public final DataAccessPoint getDataAccessPoint() {
        return this.dataAccessPoint;
    }

    public final DataService getDataService() {
        return this.dataService;
    }

    public final String getDatasetName() {
        return this.datasetName;
    }

    public void minimize() {
        this.request = null;
        this.response = null;
        this.dsg = null;
        this.dataService = null;
        this.activeDSG = null;
        this.endpoint = null;
    }

    public void setStartTime() {
        if (this.startTimeIsSet) {
            Log.warn(this, "Start time reset");
        }
        this.startTimeIsSet = true;
        this.startTime = System.nanoTime();
    }

    public long getStartTime() {
        if (!this.startTimeIsSet) {
            Log.warn(this, "Start time is not set");
        }
        return this.startTime;
    }

    public long getFinishTime() {
        if (!this.finishTimeIsSet) {
            Log.warn(this, "Finish time is not set");
        }
        return this.finishTime;
    }

    public void setFinishTime() {
        if (this.finishTimeIsSet) {
            Log.warn(this, "Finish time reset");
        }
        this.finishTimeIsSet = true;
        this.finishTime = System.nanoTime();
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponseTracker getResponse() {
        return this.response;
    }

    public long getTime() {
        if (!this.startTimeIsSet) {
            Log.warn(this, "Start time not set");
        }
        if (!this.finishTimeIsSet) {
            Log.warn(this, "Finish time not set");
        }
        return (this.finishTime - this.startTime) / 1000000L;
    }

    public void sync() {
        SystemARQ.sync(this.dsg);
    }

    public String toString() {
        return this.request.getMethod() + " " + this.request.getRequestURL().toString();
    }
}

