/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.ctl;

import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.fuseki.async.AsyncPool;
import org.apache.jena.fuseki.async.AsyncTask;
import org.apache.jena.fuseki.ctl.ActionCtl;
import org.apache.jena.fuseki.ctl.Async;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.slf4j.Logger;

public class ActionSleep
extends ActionCtl {
    public static final int MaxSleepMillis = 20000;

    @Override
    public void execOptions(HttpAction action) {
        ActionLib.doOptionsPost(action);
        ServletOps.success(action);
    }

    @Override
    public void execPost(HttpAction action) {
        super.executeLifecycle(action);
    }

    @Override
    public void validate(HttpAction action) {
    }

    @Override
    public void execute(HttpAction action) {
        SleepTask task = this.createRunnable(action);
        AsyncTask aTask = Async.execASyncTask(action, AsyncPool.get(), "sleep", task);
        action.log.info(String.format("[%d] Sleep %d ms.", action.id, task.sleepMilli));
        JsonValue v = Async.asJson(aTask);
        ServletOps.sendJsonReponse(action, v);
    }

    protected SleepTask createRunnable(HttpAction action) {
        String interval = action.request.getParameter("interval");
        int sleepMilli = 5000;
        if (interval != null) {
            try {
                sleepMilli = Integer.parseInt(interval);
            }
            catch (NumberFormatException ex) {
                ServletOps.errorBadRequest("Bad value for 'interval': integer required");
                return null;
            }
        }
        if (sleepMilli < 0) {
            ServletOps.errorBadRequest("Bad value for 'interval': negative sleep interval");
            return null;
        }
        if (sleepMilli > 20000) {
            ServletOps.errorBadRequest("Bad value for 'interval': sleep internal greater than maximum allowed");
            return null;
        }
        return new SleepTask(action, sleepMilli, AsyncPool.get());
    }

    static class SleepTask
    implements Runnable {
        private final Logger log;
        private final long actionId;
        public final int sleepMilli;
        private final AsyncPool asyncPool;

        public SleepTask(HttpAction action, int sleepMilli, AsyncPool asyncPool) {
            this.log = action.log;
            this.actionId = action.id;
            this.sleepMilli = sleepMilli;
            this.asyncPool = asyncPool;
        }

        @Override
        public void run() {
            try {
                this.log.info(String.format("[Task %d] >> Sleep start", this.actionId));
                Lib.sleep(this.sleepMilli);
                this.log.info(String.format("[Task %d] << Sleep finish", this.actionId));
            }
            catch (Exception ex) {
                this.log.info(String.format("[Task %d] **** Exception", this.actionId), ex);
                throw ex;
            }
        }
    }
}

