/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.iterator;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.iterator.IteratorWrapper;
import org.apache.jena.atlas.lib.Closeable;

public class IteratorOnClose<T>
extends IteratorWrapper<T>
implements Closeable {
    private final Runnable closeHandler;
    private boolean hasClosed = false;

    public IteratorOnClose(Iterator<T> iterator, Runnable closeHandler) {
        super(iterator);
        this.closeHandler = closeHandler;
    }

    @Override
    public boolean hasNext() {
        if (this.hasClosed) {
            return false;
        }
        boolean b = super.hasNext();
        if (!b) {
            this.close();
        }
        return b;
    }

    @Override
    public T next() {
        try {
            return this.get().next();
        }
        catch (NoSuchElementException ex) {
            this.close();
            throw ex;
        }
    }

    @Override
    public void close() {
        if (!this.hasClosed) {
            try {
                if (this.closeHandler != null) {
                    this.closeHandler.run();
                }
            }
            finally {
                this.hasClosed = true;
            }
        }
        super.close();
    }
}

