/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.data;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.jena.atlas.data.DataBag;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.FileOps;

public abstract class AbstractDataBag<E>
implements DataBag<E> {
    private final List<File> spillFiles = new ArrayList<File>();
    protected Collection<E> memory = new ArrayList();
    private final List<WeakReference<Closeable>> closeableIterators = new ArrayList<WeakReference<Closeable>>();
    protected long size = 0L;

    public boolean isEmpty() {
        return this.size == 0L;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void send(E item) {
        this.add(item);
    }

    protected File getNewTemporaryFile() {
        File sysTempDir = new File(System.getProperty("java.io.tmpdir"));
        File tmpFile = new File(sysTempDir, "DataBag-" + UUID.randomUUID().toString() + ".tmp");
        return tmpFile;
    }

    protected void registerSpillFile(File spillFile) {
        this.spillFiles.add(spillFile);
    }

    protected static OutputStream getOutputStream(File file) throws FileNotFoundException {
        return new BufferedOutputStream(new FileOutputStream(file));
    }

    protected static InputStream getInputStream(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    protected OutputStream getSpillStream() throws IOException {
        File outputFile = this.getNewTemporaryFile();
        OutputStream toReturn = AbstractDataBag.getOutputStream(outputFile);
        this.registerSpillFile(outputFile);
        return toReturn;
    }

    protected void registerCloseableIterator(Closeable c) {
        this.closeableIterators.add(new WeakReference<Closeable>(c));
    }

    protected void closeIterators() {
        this.closeableIterators.stream().map(Reference::get).filter(Objects::nonNull).forEach(Closeable::close);
    }

    protected List<File> getSpillFiles() {
        return this.spillFiles;
    }

    protected void deleteSpillFiles() {
        for (File file : this.spillFiles) {
            FileOps.delete(file, false);
        }
        this.spillFiles.clear();
    }

    protected void finalize() throws Throwable {
        this.close();
    }
}

