/*
 * Decompiled with CFR 0.152.
 */
package tdb2;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.system.Txn;
import org.apache.jena.tdb2.loader.DataLoader;
import org.apache.jena.tdb2.loader.LoaderFactory;
import org.apache.jena.tdb2.loader.base.LoaderOps;
import org.apache.jena.tdb2.loader.base.MonitorOutput;
import org.apache.jena.tdb2.loader.main.LoaderPlans;
import tdb2.cmdline.CmdTDB;
import tdb2.cmdline.CmdTDBGraph;

public class tdbloader
extends CmdTDBGraph {
    private static final ArgDecl argStats = new ArgDecl(true, "stats");
    private static final ArgDecl argLoader = new ArgDecl(true, "loader");
    private boolean showProgress = true;
    private boolean generateStats = false;
    private LoaderEnum loader = null;

    public static void main(String ... args) {
        CmdTDB.init();
        new tdbloader(args).mainRun();
    }

    protected tdbloader(String[] argv) {
        super(argv);
        super.add(argLoader, "--loader=", "Loader to use: 'basic', 'phased' (default), 'sequential', 'parallel' or 'light'");
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(argLoader)) {
            String loadername = this.getValue(argLoader).toLowerCase();
            if (loadername.matches("basic.*")) {
                this.loader = LoaderEnum.Basic;
            } else if (loadername.matches("phas.*")) {
                this.loader = LoaderEnum.Phased;
            } else if (loadername.matches("seq.*")) {
                this.loader = LoaderEnum.Sequential;
            } else if (loadername.matches("para.*")) {
                this.loader = LoaderEnum.Parallel;
            } else if (loadername.matches("para.*")) {
                this.loader = LoaderEnum.Parallel;
            } else if (loadername.matches("light")) {
                this.loader = LoaderEnum.Light;
            } else {
                throw new CmdException("Unrecognized value for --loader: " + loadername);
            }
        }
        if (super.contains(argStats)) {
            if (!this.hasValueOfTrue(argStats) && !this.hasValueOfFalse(argStats)) {
                throw new CmdException("Not a boolean value: " + this.getValue(argStats));
            }
            this.generateStats = super.hasValueOfTrue(argStats);
        }
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + "--loader= [--desc DATASET | --loc DIR] FILE ...";
    }

    @Override
    protected void exec() {
        List<String> urls;
        if (this.isVerbose()) {
            System.out.println("Java maximum memory: " + Runtime.getRuntime().maxMemory());
            System.out.println(ARQ.getContext());
        }
        if (this.isVerbose()) {
            this.showProgress = true;
        }
        if (this.isQuiet()) {
            this.showProgress = false;
        }
        if ((urls = this.getPositional()).size() == 0) {
            urls.add("-");
        } else {
            this.checkFiles(urls);
        }
        if (this.graphName == null) {
            this.loadQuads(urls);
            return;
        }
        for (String url : urls) {
            Lang lang = RDFLanguages.filenameToLang(url);
            if (lang == null || !RDFLanguages.isQuads(lang)) continue;
            throw new CmdException("Warning: Quads format given - only the default graph is loaded into the graph for --graph");
        }
        this.loadTriples(this.graphName, urls);
    }

    private void checkFiles(List<String> urls) {
        List<String> problemFiles = ListUtils.toList(urls.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(p -> !Files.exists(p, new LinkOption[0]) || !Files.isRegularFile(p, new LinkOption[0]) || !Files.isReadable(p)).map(Path::toString));
        if (!problemFiles.isEmpty()) {
            throw new CmdException("Can't read files : [" + problemFiles + "]");
        }
    }

    private void loadTriples(String graphName, List<String> urls) {
        this.execBulkLoad(super.getDatasetGraph(), graphName, urls, this.showProgress);
    }

    private void loadQuads(List<String> urls) {
        this.execBulkLoad(super.getDatasetGraph(), null, urls, this.showProgress);
    }

    private long execBulkLoad(DatasetGraph dsg, String graphName, List<String> urls, boolean showProgress) {
        DataLoader loader = this.chooseLoader(dsg, graphName);
        long elapsed = Timer.time(() -> {
            loader.startBulk();
            loader.load(urls);
            loader.finishBulk();
        });
        return elapsed;
    }

    private DataLoader chooseLoader(DatasetGraph dsg, String graphName) {
        LoaderEnum useLoader;
        Objects.requireNonNull(dsg);
        Node gn = null;
        if (graphName != null) {
            gn = NodeFactory.createURI(graphName);
        }
        if ((useLoader = this.loader) == null) {
            boolean isEmpty = Txn.calculateRead(dsg, () -> dsg.isEmpty());
            useLoader = isEmpty ? LoaderEnum.Phased : LoaderEnum.Basic;
        }
        MonitorOutput output = this.isQuiet() ? LoaderOps.nullOutput() : LoaderOps.outputToLog();
        DataLoader loader = this.createLoader(useLoader, dsg, gn, output);
        if (output != null) {
            output.print("Loader = %s", loader.getClass().getSimpleName());
        }
        return loader;
    }

    private DataLoader createLoader(LoaderEnum useLoader, DatasetGraph dsg, Node gn, MonitorOutput output) {
        switch (useLoader) {
            case Phased: {
                return LoaderFactory.phasedLoader(dsg, gn, output);
            }
            case Parallel: {
                return LoaderFactory.parallelLoader(dsg, gn, output);
            }
            case Sequential: {
                return LoaderFactory.sequentialLoader(dsg, gn, output);
            }
            case Light: {
                return LoaderFactory.createLoader(LoaderPlans.loaderPlanLight, dsg, output);
            }
            case Basic: {
                return LoaderFactory.basicLoader(dsg, gn, output);
            }
        }
        throw new InternalErrorException("Unrecognized loader: " + (Object)((Object)useLoader));
    }

    private static enum LoaderEnum {
        Basic,
        Parallel,
        Sequential,
        Light,
        Phased;

    }
}

