/*
 * Decompiled with CFR 0.152.
 */
package shacl;

import java.io.OutputStream;
import jena.cmd.ArgDecl;
import jena.cmd.CmdException;
import jena.cmd.CmdGeneral;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shacl.ValidationReport;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.validation.ValidationProc;
import org.apache.jena.sys.JenaSystem;

public class shacl_validate
extends CmdGeneral {
    private ArgDecl argOutputText = new ArgDecl(false, "--text");
    private ArgDecl argData = new ArgDecl(true, "--data", "--datafile", "-d");
    private ArgDecl argShapes = new ArgDecl(true, "--shapes", "--shapesfile", "-s");
    private String datafile = null;
    private String shapesfile = null;
    private boolean textOutput = false;

    public static void main(String ... argv) {
        new shacl_validate(argv).mainRun();
    }

    public shacl_validate(String[] argv) {
        super(argv);
        super.add(this.argShapes, "--shapes", "Shapes file");
        super.add(this.argData, "--data", "Data file");
        super.add(this.argOutputText, "--text", "Output in concise text format");
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + " --shapes shapesFile --data dataFile";
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        this.datafile = super.getValue(this.argData);
        this.shapesfile = super.getValue(this.argShapes);
        if (this.datafile == null) {
            throw new CmdException("Usage: " + this.getSummary());
        }
        if (this.shapesfile == null) {
            this.shapesfile = this.datafile;
        }
        this.textOutput = super.hasArg(this.argOutputText);
    }

    @Override
    protected void exec() {
        Graph shapesGraph = RDFDataMgr.loadGraph(this.shapesfile);
        Graph dataGraph = this.datafile.equals(this.shapesfile) ? shapesGraph : RDFDataMgr.loadGraph(this.datafile);
        ValidationReport report = ValidationProc.simpleValidation(shapesGraph, dataGraph, this.isVerbose());
        if (this.textOutput) {
            ShLib.printReport(report);
        } else {
            RDFDataMgr.write((OutputStream)System.out, report.getGraph(), Lang.TTL);
        }
    }

    @Override
    protected String getCommandName() {
        return "shacl_validate";
    }

    static {
        LogCtl.setCmdLogging();
        JenaSystem.init();
    }
}

