/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.util.IOUtils;

public class FileSwitchDirectory
extends Directory {
    private final Directory secondaryDir;
    private final Directory primaryDir;
    private final Set<String> primaryExtensions;
    private boolean doClose;

    public FileSwitchDirectory(Set<String> primaryExtensions, Directory primaryDir, Directory secondaryDir, boolean doClose) {
        this.primaryExtensions = primaryExtensions;
        this.primaryDir = primaryDir;
        this.secondaryDir = secondaryDir;
        this.doClose = doClose;
    }

    public Directory getPrimaryDir() {
        return this.primaryDir;
    }

    public Directory getSecondaryDir() {
        return this.secondaryDir;
    }

    @Override
    public Lock obtainLock(String name) throws IOException {
        return this.getDirectory(name).obtainLock(name);
    }

    @Override
    public void close() throws IOException {
        if (this.doClose) {
            IOUtils.close(this.primaryDir, this.secondaryDir);
            this.doClose = false;
        }
    }

    @Override
    public String[] listAll() throws IOException {
        NoSuchFileException exc;
        HashSet<String> files;
        block8: {
            files = new HashSet<String>();
            exc = null;
            try {
                for (String f : this.primaryDir.listAll()) {
                    files.add(f);
                }
            }
            catch (NoSuchFileException e2) {
                exc = e2;
            }
            try {
                for (String f : this.secondaryDir.listAll()) {
                    files.add(f);
                }
            }
            catch (NoSuchFileException e3) {
                if (exc != null) {
                    throw exc;
                }
                if (!files.isEmpty()) break block8;
                throw e3;
            }
        }
        if (exc != null && files.isEmpty()) {
            throw exc;
        }
        Object[] result = files.toArray(new String[files.size()]);
        Arrays.sort(result);
        return result;
    }

    public static String getExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1, name.length());
    }

    private Directory getDirectory(String name) {
        String ext = FileSwitchDirectory.getExtension(name);
        if (this.primaryExtensions.contains(ext)) {
            return this.primaryDir;
        }
        return this.secondaryDir;
    }

    @Override
    public void deleteFile(String name) throws IOException {
        if (this.getDirectory(name) == this.primaryDir) {
            this.primaryDir.deleteFile(name);
        } else {
            this.secondaryDir.deleteFile(name);
        }
    }

    @Override
    public long fileLength(String name) throws IOException {
        return this.getDirectory(name).fileLength(name);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context2) throws IOException {
        return this.getDirectory(name).createOutput(name, context2);
    }

    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context2) throws IOException {
        return this.getDirectory("." + suffix).createTempOutput(prefix, suffix, context2);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        ArrayList<String> primaryNames = new ArrayList<String>();
        ArrayList<String> secondaryNames = new ArrayList<String>();
        for (String name : names) {
            if (this.primaryExtensions.contains(FileSwitchDirectory.getExtension(name))) {
                primaryNames.add(name);
                continue;
            }
            secondaryNames.add(name);
        }
        this.primaryDir.sync(primaryNames);
        this.secondaryDir.sync(secondaryNames);
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        Directory sourceDir = this.getDirectory(source);
        if (sourceDir != this.getDirectory(dest)) {
            throw new AtomicMoveNotSupportedException(source, dest, "source and dest are in different directories");
        }
        sourceDir.rename(source, dest);
    }

    @Override
    public void syncMetaData() throws IOException {
        this.primaryDir.syncMetaData();
        this.secondaryDir.syncMetaData();
    }

    @Override
    public IndexInput openInput(String name, IOContext context2) throws IOException {
        return this.getDirectory(name).openInput(name, context2);
    }

    @Override
    public Set<String> getPendingDeletions() throws IOException {
        Set<String> primaryDeletions = this.primaryDir.getPendingDeletions();
        Set<String> secondaryDeletions = this.secondaryDir.getPendingDeletions();
        if (primaryDeletions.isEmpty() && secondaryDeletions.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> combined = new HashSet<String>();
        combined.addAll(primaryDeletions);
        combined.addAll(secondaryDeletions);
        return Collections.unmodifiableSet(combined);
    }
}

