/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;

public abstract class BufferedIndexInput
extends IndexInput
implements RandomAccessInput {
    public static final int BUFFER_SIZE = 1024;
    public static final int MIN_BUFFER_SIZE = 8;
    public static final int MERGE_BUFFER_SIZE = 4096;
    private int bufferSize = 1024;
    protected byte[] buffer;
    private long bufferStart = 0L;
    private int bufferLength = 0;
    private int bufferPosition = 0;

    @Override
    public final byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            this.refill();
        }
        return this.buffer[this.bufferPosition++];
    }

    public BufferedIndexInput(String resourceDesc) {
        this(resourceDesc, 1024);
    }

    public BufferedIndexInput(String resourceDesc, IOContext context2) {
        this(resourceDesc, BufferedIndexInput.bufferSize(context2));
    }

    public BufferedIndexInput(String resourceDesc, int bufferSize) {
        super(resourceDesc);
        this.checkBufferSize(bufferSize);
        this.bufferSize = bufferSize;
    }

    public final void setBufferSize(int newSize) {
        assert (this.buffer == null || this.bufferSize == this.buffer.length) : "buffer=" + this.buffer + " bufferSize=" + this.bufferSize + " buffer.length=" + (this.buffer != null ? this.buffer.length : 0);
        if (newSize != this.bufferSize) {
            this.checkBufferSize(newSize);
            this.bufferSize = newSize;
            if (this.buffer != null) {
                byte[] newBuffer = new byte[newSize];
                int leftInBuffer = this.bufferLength - this.bufferPosition;
                int numToCopy = leftInBuffer > newSize ? newSize : leftInBuffer;
                System.arraycopy(this.buffer, this.bufferPosition, newBuffer, 0, numToCopy);
                this.bufferStart += (long)this.bufferPosition;
                this.bufferPosition = 0;
                this.bufferLength = numToCopy;
                this.newBuffer(newBuffer);
            }
        }
    }

    protected void newBuffer(byte[] newBuffer) {
        this.buffer = newBuffer;
    }

    public final int getBufferSize() {
        return this.bufferSize;
    }

    private void checkBufferSize(int bufferSize) {
        if (bufferSize < 8) {
            throw new IllegalArgumentException("bufferSize must be at least MIN_BUFFER_SIZE (got " + bufferSize + ")");
        }
    }

    @Override
    public final void readBytes(byte[] b, int offset, int len) throws IOException {
        this.readBytes(b, offset, len, true);
    }

    @Override
    public final void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        int available = this.bufferLength - this.bufferPosition;
        if (len <= available) {
            if (len > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, b, offset, len);
            }
            this.bufferPosition += len;
        } else {
            if (available > 0) {
                System.arraycopy(this.buffer, this.bufferPosition, b, offset, available);
                offset += available;
                len -= available;
                this.bufferPosition += available;
            }
            if (useBuffer && len < this.bufferSize) {
                this.refill();
                if (this.bufferLength < len) {
                    System.arraycopy(this.buffer, 0, b, offset, this.bufferLength);
                    throw new EOFException("read past EOF: " + this);
                }
                System.arraycopy(this.buffer, 0, b, offset, len);
                this.bufferPosition = len;
            } else {
                long after = this.bufferStart + (long)this.bufferPosition + (long)len;
                if (after > this.length()) {
                    throw new EOFException("read past EOF: " + this);
                }
                this.readInternal(b, offset, len);
                this.bufferStart = after;
                this.bufferPosition = 0;
                this.bufferLength = 0;
            }
        }
    }

    @Override
    public final short readShort() throws IOException {
        if (2 <= this.bufferLength - this.bufferPosition) {
            return (short)((this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF);
        }
        return super.readShort();
    }

    @Override
    public final int readInt() throws IOException {
        if (4 <= this.bufferLength - this.bufferPosition) {
            return (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
        }
        return super.readInt();
    }

    @Override
    public final long readLong() throws IOException {
        if (8 <= this.bufferLength - this.bufferPosition) {
            int i1 = (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
            int i2 = (this.buffer[this.bufferPosition++] & 0xFF) << 24 | (this.buffer[this.bufferPosition++] & 0xFF) << 16 | (this.buffer[this.bufferPosition++] & 0xFF) << 8 | this.buffer[this.bufferPosition++] & 0xFF;
            return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
        }
        return super.readLong();
    }

    @Override
    public final int readVInt() throws IOException {
        if (5 <= this.bufferLength - this.bufferPosition) {
            byte b;
            if ((b = this.buffer[this.bufferPosition++]) >= 0) {
                return b;
            }
            int i = b & 0x7F;
            b = this.buffer[this.bufferPosition++];
            i |= (b & 0x7F) << 7;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= (b & 0x7F) << 14;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= (b & 0x7F) << 21;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= (b & 0xF) << 28;
            if ((b & 0xF0) == 0) {
                return i;
            }
            throw new IOException("Invalid vInt detected (too many bits)");
        }
        return super.readVInt();
    }

    @Override
    public final long readVLong() throws IOException {
        if (9 <= this.bufferLength - this.bufferPosition) {
            byte b;
            if ((b = this.buffer[this.bufferPosition++]) >= 0) {
                return b;
            }
            long i = (long)b & 0x7FL;
            b = this.buffer[this.bufferPosition++];
            i |= ((long)b & 0x7FL) << 7;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= ((long)b & 0x7FL) << 14;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= ((long)b & 0x7FL) << 21;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= ((long)b & 0x7FL) << 28;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= ((long)b & 0x7FL) << 35;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= ((long)b & 0x7FL) << 42;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= ((long)b & 0x7FL) << 49;
            if (b >= 0) {
                return i;
            }
            b = this.buffer[this.bufferPosition++];
            i |= ((long)b & 0x7FL) << 56;
            if (b >= 0) {
                return i;
            }
            throw new IOException("Invalid vLong detected (negative values disallowed)");
        }
        return super.readVLong();
    }

    @Override
    public final byte readByte(long pos) throws IOException {
        long index = pos - this.bufferStart;
        if (index < 0L || index >= (long)this.bufferLength) {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
            this.refill();
            index = 0L;
        }
        return this.buffer[(int)index];
    }

    @Override
    public final short readShort(long pos) throws IOException {
        long index = pos - this.bufferStart;
        if (index < 0L || index >= (long)(this.bufferLength - 1)) {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
            this.refill();
            index = 0L;
        }
        return (short)((this.buffer[(int)index] & 0xFF) << 8 | this.buffer[(int)index + 1] & 0xFF);
    }

    @Override
    public final int readInt(long pos) throws IOException {
        long index = pos - this.bufferStart;
        if (index < 0L || index >= (long)(this.bufferLength - 3)) {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
            this.refill();
            index = 0L;
        }
        return (this.buffer[(int)index] & 0xFF) << 24 | (this.buffer[(int)index + 1] & 0xFF) << 16 | (this.buffer[(int)index + 2] & 0xFF) << 8 | this.buffer[(int)index + 3] & 0xFF;
    }

    @Override
    public final long readLong(long pos) throws IOException {
        long index = pos - this.bufferStart;
        if (index < 0L || index >= (long)(this.bufferLength - 7)) {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
            this.refill();
            index = 0L;
        }
        int i1 = (this.buffer[(int)index] & 0xFF) << 24 | (this.buffer[(int)index + 1] & 0xFF) << 16 | (this.buffer[(int)index + 2] & 0xFF) << 8 | this.buffer[(int)index + 3] & 0xFF;
        int i2 = (this.buffer[(int)index + 4] & 0xFF) << 24 | (this.buffer[(int)index + 5] & 0xFF) << 16 | (this.buffer[(int)index + 6] & 0xFF) << 8 | this.buffer[(int)index + 7] & 0xFF;
        return (long)i1 << 32 | (long)i2 & 0xFFFFFFFFL;
    }

    private void refill() throws IOException {
        int newLength;
        long start = this.bufferStart + (long)this.bufferPosition;
        long end = start + (long)this.bufferSize;
        if (end > this.length()) {
            end = this.length();
        }
        if ((newLength = (int)(end - start)) <= 0) {
            throw new EOFException("read past EOF: " + this);
        }
        if (this.buffer == null) {
            this.newBuffer(new byte[this.bufferSize]);
            this.seekInternal(this.bufferStart);
        }
        this.readInternal(this.buffer, 0, newLength);
        this.bufferLength = newLength;
        this.bufferStart = start;
        this.bufferPosition = 0;
    }

    protected abstract void readInternal(byte[] var1, int var2, int var3) throws IOException;

    @Override
    public final long getFilePointer() {
        return this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public final void seek(long pos) throws IOException {
        if (pos >= this.bufferStart && pos < this.bufferStart + (long)this.bufferLength) {
            this.bufferPosition = (int)(pos - this.bufferStart);
        } else {
            this.bufferStart = pos;
            this.bufferPosition = 0;
            this.bufferLength = 0;
            this.seekInternal(pos);
        }
    }

    protected abstract void seekInternal(long var1) throws IOException;

    @Override
    public BufferedIndexInput clone() {
        BufferedIndexInput clone = (BufferedIndexInput)super.clone();
        clone.buffer = null;
        clone.bufferLength = 0;
        clone.bufferPosition = 0;
        clone.bufferStart = this.getFilePointer();
        return clone;
    }

    @Override
    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return BufferedIndexInput.wrap(sliceDescription, this, offset, length);
    }

    protected final int flushBuffer(IndexOutput out, long numBytes) throws IOException {
        int toCopy = this.bufferLength - this.bufferPosition;
        if ((long)toCopy > numBytes) {
            toCopy = (int)numBytes;
        }
        if (toCopy > 0) {
            out.writeBytes(this.buffer, this.bufferPosition, toCopy);
            this.bufferPosition += toCopy;
        }
        return toCopy;
    }

    public static int bufferSize(IOContext context2) {
        switch (context2.context) {
            case MERGE: {
                return 4096;
            }
        }
        return 1024;
    }

    public static BufferedIndexInput wrap(String sliceDescription, IndexInput other, long offset, long length) {
        return new SlicedIndexInput(sliceDescription, other, offset, length);
    }

    private static final class SlicedIndexInput
    extends BufferedIndexInput {
        IndexInput base;
        long fileOffset;
        long length;

        SlicedIndexInput(String sliceDescription, IndexInput base, long offset, long length) {
            super(sliceDescription == null ? base.toString() : base.toString() + " [slice=" + sliceDescription + "]", 1024);
            if (offset < 0L || length < 0L || offset + length > base.length()) {
                throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: " + base);
            }
            this.base = base.clone();
            this.fileOffset = offset;
            this.length = length;
        }

        @Override
        public SlicedIndexInput clone() {
            SlicedIndexInput clone = (SlicedIndexInput)super.clone();
            clone.base = this.base.clone();
            clone.fileOffset = this.fileOffset;
            clone.length = this.length;
            return clone;
        }

        @Override
        protected void readInternal(byte[] b, int offset, int len) throws IOException {
            long start = this.getFilePointer();
            if (start + (long)len > this.length) {
                throw new EOFException("read past EOF: " + this);
            }
            this.base.seek(this.fileOffset + start);
            this.base.readBytes(b, offset, len, false);
        }

        @Override
        protected void seekInternal(long pos) {
        }

        @Override
        public void close() throws IOException {
            this.base.close();
        }

        @Override
        public long length() {
            return this.length;
        }
    }
}

