/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.TermsQuery;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.FixedBitSet;

class TermsIncludingScoreQuery
extends Query {
    private final ScoreMode scoreMode;
    private final String toField;
    private final boolean multipleValuesPerDocument;
    private final BytesRefHash terms;
    private final float[] scores;
    private final int[] ords;
    private final Query fromQuery;
    private final String fromField;
    private final Object topReaderContextId;

    TermsIncludingScoreQuery(ScoreMode scoreMode, String toField, boolean multipleValuesPerDocument, BytesRefHash terms, float[] scores, String fromField, Query fromQuery, Object indexReaderContextId) {
        this.scoreMode = scoreMode;
        this.toField = toField;
        this.multipleValuesPerDocument = multipleValuesPerDocument;
        this.terms = terms;
        this.scores = scores;
        this.ords = terms.sort();
        this.fromField = fromField;
        this.fromQuery = fromQuery;
        this.topReaderContextId = indexReaderContextId;
    }

    @Override
    public String toString(String string) {
        return String.format(Locale.ROOT, "TermsIncludingScoreQuery{field=%s;fromQuery=%s}", this.toField, this.fromQuery);
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((TermsIncludingScoreQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(TermsIncludingScoreQuery other) {
        return Objects.equals((Object)this.scoreMode, (Object)other.scoreMode) && Objects.equals(this.toField, other.toField) && Objects.equals(this.fromField, other.fromField) && Objects.equals(this.fromQuery, other.fromQuery) && Objects.equals(this.topReaderContextId, other.topReaderContextId);
    }

    @Override
    public int hashCode() {
        return this.classHash() + Objects.hash(new Object[]{this.scoreMode, this.toField, this.fromField, this.fromQuery, this.topReaderContextId});
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        if (!needsScores) {
            TermsQuery termsQuery = new TermsQuery(this.toField, this.terms, this.fromField, this.fromQuery, this.topReaderContextId);
            return searcher.rewrite(termsQuery).createWeight(searcher, false, boost);
        }
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
                Terms terms = context2.reader().terms(TermsIncludingScoreQuery.this.toField);
                if (terms != null) {
                    TermsEnum segmentTermsEnum = terms.iterator();
                    BytesRef spare = new BytesRef();
                    PostingsEnum postingsEnum = null;
                    for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                        if (!segmentTermsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare)) || (postingsEnum = segmentTermsEnum.postings(postingsEnum, 0)).advance(doc) != doc) continue;
                        float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                        return Explanation.match(score, "Score based on join value " + segmentTermsEnum.term().utf8ToString(), new Explanation[0]);
                    }
                }
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }

            @Override
            public Scorer scorer(LeafReaderContext context2) throws IOException {
                Terms terms = context2.reader().terms(TermsIncludingScoreQuery.this.toField);
                if (terms == null) {
                    return null;
                }
                long cost = (long)context2.reader().maxDoc() * terms.size();
                TermsEnum segmentTermsEnum = terms.iterator();
                if (TermsIncludingScoreQuery.this.multipleValuesPerDocument) {
                    return new MVInOrderScorer(this, segmentTermsEnum, context2.reader().maxDoc(), cost);
                }
                return new SVInOrderScorer(this, segmentTermsEnum, context2.reader().maxDoc(), cost);
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }
        };
    }

    class MVInOrderScorer
    extends SVInOrderScorer {
        MVInOrderScorer(Weight weight, TermsEnum termsEnum, int maxDoc, long cost) throws IOException {
            super(weight, termsEnum, maxDoc, cost);
        }

        @Override
        protected void fillDocsAndScores(FixedBitSet matchingDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            PostingsEnum postingsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = postingsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    if (!matchingDocs.get(doc)) {
                        this.scores[doc] = score;
                        matchingDocs.set(doc);
                    }
                    doc = postingsEnum.nextDoc();
                }
            }
        }
    }

    class SVInOrderScorer
    extends Scorer {
        final DocIdSetIterator matchingDocsIterator;
        final float[] scores;
        final long cost;

        SVInOrderScorer(Weight weight, TermsEnum termsEnum, int maxDoc, long cost) throws IOException {
            super(weight);
            FixedBitSet matchingDocs = new FixedBitSet(maxDoc);
            this.scores = new float[maxDoc];
            this.fillDocsAndScores(matchingDocs, termsEnum);
            this.matchingDocsIterator = new BitSetIterator(matchingDocs, cost);
            this.cost = cost;
        }

        protected void fillDocsAndScores(FixedBitSet matchingDocs, TermsEnum termsEnum) throws IOException {
            BytesRef spare = new BytesRef();
            PostingsEnum postingsEnum = null;
            for (int i = 0; i < TermsIncludingScoreQuery.this.terms.size(); ++i) {
                if (!termsEnum.seekExact(TermsIncludingScoreQuery.this.terms.get(TermsIncludingScoreQuery.this.ords[i], spare))) continue;
                postingsEnum = termsEnum.postings(postingsEnum, 0);
                float score = TermsIncludingScoreQuery.this.scores[TermsIncludingScoreQuery.this.ords[i]];
                int doc = postingsEnum.nextDoc();
                while (doc != Integer.MAX_VALUE) {
                    matchingDocs.set(doc);
                    this.scores[doc] = score;
                    doc = postingsEnum.nextDoc();
                }
            }
        }

        @Override
        public float score() throws IOException {
            return this.scores[this.docID()];
        }

        @Override
        public int docID() {
            return this.matchingDocsIterator.docID();
        }

        @Override
        public DocIdSetIterator iterator() {
            return this.matchingDocsIterator;
        }
    }
}

