/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilterWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BaseGlobalOrdinalScorer;
import org.apache.lucene.search.join.GlobalOrdinalsQuery;
import org.apache.lucene.search.join.GlobalOrdinalsWithScoreCollector;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;

final class GlobalOrdinalsWithScoreQuery
extends Query {
    private final GlobalOrdinalsWithScoreCollector collector;
    private final String joinField;
    private final OrdinalMap globalOrds;
    private final Query toQuery;
    private final ScoreMode scoreMode;
    private final Query fromQuery;
    private final int min;
    private final int max;
    private final Object indexReaderContextId;

    GlobalOrdinalsWithScoreQuery(GlobalOrdinalsWithScoreCollector collector, ScoreMode scoreMode, String joinField, OrdinalMap globalOrds, Query toQuery, Query fromQuery, int min2, int max2, Object indexReaderContextId) {
        this.collector = collector;
        this.joinField = joinField;
        this.globalOrds = globalOrds;
        this.toQuery = toQuery;
        this.scoreMode = scoreMode;
        this.fromQuery = fromQuery;
        this.min = min2;
        this.max = max2;
        this.indexReaderContextId = indexReaderContextId;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        boolean doNoMinMax;
        if (searcher.getTopReaderContext().id() != this.indexReaderContextId) {
            throw new IllegalStateException("Creating the weight against a different index reader than this query has been built for.");
        }
        boolean bl = doNoMinMax = this.min <= 0 && this.max == Integer.MAX_VALUE;
        if (!needsScores && doNoMinMax) {
            GlobalOrdinalsQuery globalOrdinalsQuery = new GlobalOrdinalsQuery(this.collector.collectedOrds, this.joinField, this.globalOrds, this.toQuery, this.fromQuery, this.indexReaderContextId);
            return globalOrdinalsQuery.createWeight(searcher, false, boost);
        }
        return new W(this, this.toQuery.createWeight(searcher, false, 1.0f));
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((GlobalOrdinalsWithScoreQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(GlobalOrdinalsWithScoreQuery other) {
        return this.min == other.min && this.max == other.max && this.scoreMode.equals((Object)other.scoreMode) && this.joinField.equals(other.joinField) && this.fromQuery.equals(other.fromQuery) && this.toQuery.equals(other.toQuery) && this.indexReaderContextId.equals(other.indexReaderContextId);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.scoreMode.hashCode();
        result = 31 * result + this.joinField.hashCode();
        result = 31 * result + this.toQuery.hashCode();
        result = 31 * result + this.fromQuery.hashCode();
        result = 31 * result + this.min;
        result = 31 * result + this.max;
        result = 31 * result + this.indexReaderContextId.hashCode();
        return result;
    }

    @Override
    public String toString(String field) {
        return "GlobalOrdinalsQuery{joinField=" + this.joinField + "min=" + this.min + "max=" + this.max + "fromQuery=" + this.fromQuery + '}';
    }

    static final class SegmentOrdinalScorer
    extends BaseGlobalOrdinalScorer {
        final GlobalOrdinalsWithScoreCollector collector;

        public SegmentOrdinalScorer(Weight weight, GlobalOrdinalsWithScoreCollector collector, SortedDocValues values, DocIdSetIterator approximation) {
            super(weight, values, approximation);
            this.collector = collector;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    int segmentOrd;
                    if (values.advanceExact(this.approximation.docID()) && collector.match(segmentOrd = values.ordValue())) {
                        score = collector.score(segmentOrd);
                        return true;
                    }
                    return false;
                }

                @Override
                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    static final class OrdinalMapScorer
    extends BaseGlobalOrdinalScorer {
        final LongValues segmentOrdToGlobalOrdLookup;
        final GlobalOrdinalsWithScoreCollector collector;

        public OrdinalMapScorer(Weight weight, GlobalOrdinalsWithScoreCollector collector, SortedDocValues values, DocIdSetIterator approximation, LongValues segmentOrdToGlobalOrdLookup) {
            super(weight, values, approximation);
            this.segmentOrdToGlobalOrdLookup = segmentOrdToGlobalOrdLookup;
            this.collector = collector;
        }

        @Override
        protected TwoPhaseIterator createTwoPhaseIterator(DocIdSetIterator approximation) {
            return new TwoPhaseIterator(approximation){

                @Override
                public boolean matches() throws IOException {
                    long segmentOrd;
                    int globalOrd;
                    if (values.advanceExact(this.approximation.docID()) && collector.match(globalOrd = (int)segmentOrdToGlobalOrdLookup.get(segmentOrd = (long)values.ordValue()))) {
                        score = collector.score(globalOrd);
                        return true;
                    }
                    return false;
                }

                @Override
                public float matchCost() {
                    return 100.0f;
                }
            };
        }
    }

    final class W
    extends FilterWeight {
        W(Query query2, Weight approximationWeight) {
            super(query2, approximationWeight);
        }

        @Override
        public void extractTerms(Set<Term> terms) {
        }

        @Override
        public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
            SortedDocValues values = DocValues.getSorted(context2.reader(), GlobalOrdinalsWithScoreQuery.this.joinField);
            if (values == null) {
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }
            if (values.advance(doc) != doc) {
                return Explanation.noMatch("Not a match", new Explanation[0]);
            }
            int segmentOrd = values.ordValue();
            BytesRef joinValue = values.lookupOrd(segmentOrd);
            int ord = GlobalOrdinalsWithScoreQuery.this.globalOrds != null ? (int)GlobalOrdinalsWithScoreQuery.this.globalOrds.getGlobalOrds(context2.ord).get(segmentOrd) : segmentOrd;
            if (!GlobalOrdinalsWithScoreQuery.this.collector.match(ord)) {
                return Explanation.noMatch("Not a match, join value " + Term.toString(joinValue), new Explanation[0]);
            }
            float score = GlobalOrdinalsWithScoreQuery.this.collector.score(ord);
            return Explanation.match(score, "A match, join value " + Term.toString(joinValue), new Explanation[0]);
        }

        @Override
        public Scorer scorer(LeafReaderContext context2) throws IOException {
            SortedDocValues values = DocValues.getSorted(context2.reader(), GlobalOrdinalsWithScoreQuery.this.joinField);
            if (values == null) {
                return null;
            }
            Scorer approximationScorer = this.in.scorer(context2);
            if (approximationScorer == null) {
                return null;
            }
            if (GlobalOrdinalsWithScoreQuery.this.globalOrds != null) {
                return new OrdinalMapScorer(this, GlobalOrdinalsWithScoreQuery.this.collector, values, approximationScorer.iterator(), GlobalOrdinalsWithScoreQuery.this.globalOrds.getGlobalOrds(context2.ord));
            }
            return new SegmentOrdinalScorer(this, GlobalOrdinalsWithScoreQuery.this.collector, values, approximationScorer.iterator());
        }
    }
}

