/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;

public class CheckJoinIndex {
    private CheckJoinIndex() {
    }

    public static void check(IndexReader reader, BitSetProducer parentsFilter) throws IOException {
        for (LeafReaderContext context2 : reader.leaves()) {
            if (context2.reader().maxDoc() == 0) continue;
            BitSet parents = parentsFilter.getBitSet(context2);
            if (parents == null || parents.cardinality() == 0) {
                throw new IllegalStateException("Every segment should have at least one parent, but " + context2.reader() + " does not have any");
            }
            if (!parents.get(context2.reader().maxDoc() - 1)) {
                throw new IllegalStateException("The last document of a segment must always be a parent, but " + context2.reader() + " has a child as a last doc");
            }
            Bits liveDocs = context2.reader().getLiveDocs();
            if (liveDocs == null) continue;
            int prevParentDoc = -1;
            BitSetIterator it = new BitSetIterator(parents, 0L);
            int parentDoc = ((DocIdSetIterator)it).nextDoc();
            while (parentDoc != Integer.MAX_VALUE) {
                boolean parentIsLive = liveDocs.get(parentDoc);
                for (int child = prevParentDoc + 1; child != parentDoc; ++child) {
                    boolean childIsLive = liveDocs.get(child);
                    if (parentIsLive == childIsLive) continue;
                    if (childIsLive) {
                        throw new IllegalStateException("Parent doc " + parentDoc + " of segment " + context2.reader() + " is live but has a deleted child document " + child);
                    }
                    throw new IllegalStateException("Parent doc " + parentDoc + " of segment " + context2.reader() + " is deleted but has a live child document " + child);
                }
                prevParentDoc = parentDoc;
                parentDoc = ((DocIdSetIterator)it).nextDoc();
            }
        }
    }
}

