/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermMatchesIterator;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

public class TermQuery
extends Query {
    private final Term term;
    private final TermContext perReaderTermState;

    public TermQuery(Term t) {
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = null;
    }

    public TermQuery(Term t, TermContext states) {
        assert (states != null);
        this.term = Objects.requireNonNull(t);
        this.perReaderTermState = Objects.requireNonNull(states);
    }

    public Term getTerm() {
        return this.term;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) throws IOException {
        IndexReaderContext context2 = searcher.getTopReaderContext();
        TermContext termState = this.perReaderTermState == null || !this.perReaderTermState.wasBuiltFor(context2) ? (needsScores ? TermContext.build(context2, this.term) : null) : this.perReaderTermState;
        return new TermWeight(searcher, needsScores, boost, termState);
    }

    @Override
    public String toString(String field) {
        StringBuilder buffer = new StringBuilder();
        if (!this.term.field().equals(field)) {
            buffer.append(this.term.field());
            buffer.append(":");
        }
        buffer.append(this.term.text());
        return buffer.toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.term.equals(((TermQuery)other).term);
    }

    @Override
    public int hashCode() {
        return this.classHash() ^ this.term.hashCode();
    }

    final class TermWeight
    extends Weight {
        private final Similarity similarity;
        private final Similarity.SimWeight stats;
        private final TermContext termStates;
        private final boolean needsScores;

        public TermWeight(IndexSearcher searcher, boolean needsScores, float boost, TermContext termStates) throws IOException {
            TermStatistics termStats;
            CollectionStatistics collectionStats;
            super(TermQuery.this);
            if (needsScores && termStates == null) {
                throw new IllegalStateException("termStates are required when scores are needed");
            }
            this.needsScores = needsScores;
            this.termStates = termStates;
            this.similarity = searcher.getSimilarity(needsScores);
            if (needsScores) {
                collectionStats = searcher.collectionStatistics(TermQuery.this.term.field());
                termStats = searcher.termStatistics(TermQuery.this.term, termStates);
            } else {
                int maxDoc = searcher.getIndexReader().maxDoc();
                collectionStats = new CollectionStatistics(TermQuery.this.term.field(), maxDoc, -1L, -1L, -1L);
                termStats = new TermStatistics(TermQuery.this.term.bytes(), maxDoc, -1L);
            }
            this.stats = this.similarity.computeWeight(boost, collectionStats, termStats);
        }

        @Override
        public void extractTerms(Set<Term> terms) {
            terms.add(TermQuery.this.getTerm());
        }

        @Override
        public Matches matches(LeafReaderContext context2, int doc) throws IOException {
            TermsEnum te = this.getTermsEnum(context2);
            if (te == null) {
                return null;
            }
            if (!context2.reader().terms(TermQuery.this.term.field()).hasPositions()) {
                return super.matches(context2, doc);
            }
            return Matches.forField(TermQuery.this.term.field(), () -> {
                PostingsEnum pe = te.postings(null, 56);
                if (pe.advance(doc) != doc) {
                    return null;
                }
                return new TermMatchesIterator(pe);
            });
        }

        public String toString() {
            return "weight(" + TermQuery.this + ")";
        }

        @Override
        public Scorer scorer(LeafReaderContext context2) throws IOException {
            assert (this.termStates == null || this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context2))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext(context2);
            TermsEnum termsEnum = this.getTermsEnum(context2);
            if (termsEnum == null) {
                return null;
            }
            PostingsEnum docs = termsEnum.postings(null, this.needsScores ? 8 : 0);
            assert (docs != null);
            return new TermScorer(this, docs, this.similarity.simScorer(this.stats, context2));
        }

        @Override
        public boolean isCacheable(LeafReaderContext ctx) {
            return true;
        }

        private TermsEnum getTermsEnum(LeafReaderContext context2) throws IOException {
            if (this.termStates != null) {
                assert (this.termStates.wasBuiltFor(ReaderUtil.getTopLevelContext(context2))) : "The top-reader used to create Weight is not the same as the current reader's top-reader (" + ReaderUtil.getTopLevelContext(context2);
                TermState state = this.termStates.get(context2.ord);
                if (state == null) {
                    assert (this.termNotInReader(context2.reader(), TermQuery.this.term)) : "no termstate found but term exists in reader term=" + TermQuery.access$000(TermQuery.this);
                    return null;
                }
                TermsEnum termsEnum = context2.reader().terms(TermQuery.this.term.field()).iterator();
                termsEnum.seekExact(TermQuery.this.term.bytes(), state);
                return termsEnum;
            }
            Terms terms = context2.reader().terms(TermQuery.this.term.field());
            if (terms == null) {
                return null;
            }
            TermsEnum termsEnum = terms.iterator();
            if (termsEnum.seekExact(TermQuery.this.term.bytes())) {
                return termsEnum;
            }
            return null;
        }

        private boolean termNotInReader(LeafReader reader, Term term) throws IOException {
            return reader.docFreq(term) == 0;
        }

        @Override
        public Explanation explain(LeafReaderContext context2, int doc) throws IOException {
            int newDoc;
            TermScorer scorer = (TermScorer)this.scorer(context2);
            if (scorer != null && (newDoc = scorer.iterator().advance(doc)) == doc) {
                float freq = scorer.freq();
                Similarity.SimScorer docScorer = this.similarity.simScorer(this.stats, context2);
                Explanation freqExplanation = Explanation.match(freq, "termFreq=" + freq, new Explanation[0]);
                Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
                return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
            }
            return Explanation.noMatch("no matching term", new Explanation[0]);
        }
    }
}

