/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;

public final class MatchAllDocsQuery
extends Query {
    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores, float boost) {
        return new ConstantScoreWeight(this, boost){

            public String toString() {
                return "weight(" + MatchAllDocsQuery.this + ")";
            }

            @Override
            public Scorer scorer(LeafReaderContext context2) throws IOException {
                return new ConstantScoreScorer((Weight)this, this.score(), DocIdSetIterator.all(context2.reader().maxDoc()));
            }

            @Override
            public boolean isCacheable(LeafReaderContext ctx) {
                return true;
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context2) throws IOException {
                final float score = this.score();
                final int maxDoc = context2.reader().maxDoc();
                return new BulkScorer(){

                    @Override
                    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
                        max2 = Math.min(max2, maxDoc);
                        FakeScorer scorer = new FakeScorer();
                        scorer.score = score;
                        collector.setScorer(scorer);
                        for (int doc = min2; doc < max2; ++doc) {
                            scorer.doc = doc;
                            if (acceptDocs != null && !acceptDocs.get(doc)) continue;
                            collector.collect(doc);
                        }
                        return max2 == maxDoc ? Integer.MAX_VALUE : max2;
                    }

                    @Override
                    public long cost() {
                        return maxDoc;
                    }
                };
            }
        };
    }

    @Override
    public String toString(String field) {
        return "*:*";
    }

    @Override
    public boolean equals(Object o) {
        return this.sameClassAs(o);
    }

    @Override
    public int hashCode() {
        return this.classHash();
    }
}

